/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _XMLSECURITY_WARNINGS_HXX
#define _XMLSECURITY_WARNINGS_HXX

#include <vcl/dialog.hxx>
#include <svtools/stdctrl.hxx>
#include <vcl/button.hxx>
#include <svx/simptabl.hxx>

namespace com {
namespace sun {
namespace star {
namespace security {
    class XCertificate; }
namespace xml { namespace crypto {
    class XSecurityEnvironment; }}
}}}

#include <com/sun/star/uno/Sequence.hxx>
#include <xmlsecurity/sigstruct.hxx>

namespace css = com::sun::star;
namespace cssu = com::sun::star::uno;
namespace dcss = ::com::sun::star;

class HeaderBar;

class MacroWarning : public ModalDialog
{
private:
	// XSecurityEnvironment is needed for building the certification path
	cssu::Reference< dcss::xml::crypto::XSecurityEnvironment > mxSecurityEnvironment;

//	cssu::Sequence< cssu::Reference< dcss::security::XCertificate > > maCerts;
	cssu::Reference< dcss::security::XCertificate > mxCert;

//	FixedImage			maQuestionMarkFI;
	FixedInfo			maDocNameFI;
	FixedInfo			maDescr1aFI;
	FixedInfo			maDescr1bFI;
	FixedInfo			maSignsFI;
	PushButton			maViewSignsBtn;
	FixedInfo			maDescr2FI;
	CheckBox			maAlwaysTrustCB;
	FixedLine			maBottomSepFL;
	PushButton			maEnableBtn;
	CancelButton		maDisableBtn;
	HelpButton			maHelpBtn;

	const bool			mbSignedMode;			// modus of dialog (signed / unsigned macros)

	DECL_LINK(			ViewSignsBtnHdl, void* );
	DECL_LINK(			EnableBtnHdl, void* );
//	DECL_LINK(			DisableBtnHdl, void* );

public:
	MacroWarning( Window* pParent, cssu::Reference< dcss::xml::crypto::XSecurityEnvironment >& _rxSecurityEnvironment, cssu::Reference< dcss::security::XCertificate >& _rxCert );
	MacroWarning( Window* pParent );
	~MacroWarning();
};

#endif

