/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _XMLOFF_FLATTCONTEXT_HXX
#define _XMLOFF_FLATTCONTEXT_HXX

#include "PersAttrListTContext.hxx"


class XMLPersTextContentTContext : public XMLPersAttrListTContext
{
	::rtl::OUString m_aCharacters;

public:
	TYPEINFO();

	// A contexts constructor does anything that is required if an element
	// starts. Namespace processing has been done already.
	// Note that virtual methods cannot be used inside constructors. Use
	// StartElement instead if this is required.
	XMLPersTextContentTContext( XMLTransformerBase& rTransformer, 
						   const ::rtl::OUString& rQName );

	// attr list/text content persistence + renaming
	XMLPersTextContentTContext( XMLTransformerBase& rTransformer, 
						   const ::rtl::OUString& rQName,
		   				   sal_uInt16 nPrefix,
		   				   ::xmloff::token::XMLTokenEnum eToken );

	// A contexts destructor does anything that is required if an element
	// ends. By default, nothing is done.
	// Note that virtual methods cannot be used inside destructors. Use
	// EndElement instead if this is required.
	virtual ~XMLPersTextContentTContext();

	// This method is called for all characters that are contained in the
	// current element.
	virtual void Characters( const ::rtl::OUString& rChars );

	virtual void ExportContent();

	const ::rtl::OUString& GetTextContent() const { return m_aCharacters; }
};

#endif	//  _XMLOFF_FLATTCONTEXT_HXX

