/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"
#include "FlatTContext.hxx"
#ifndef _XMLOFF_TRANSFORMERBASE_HXX
#include "TransformerBase.hxx"
#endif

using ::rtl::OUString;

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;

TYPEINIT1( XMLPersTextContentTContext, XMLPersAttrListTContext );

XMLPersTextContentTContext::XMLPersTextContentTContext( 
		XMLTransformerBase& rImp, 
		const OUString& rQName ) :
	XMLPersAttrListTContext( rImp, rQName )
{
}

XMLPersTextContentTContext::XMLPersTextContentTContext( 
		XMLTransformerBase& rImp, 
		const OUString& rQName,
	    sal_uInt16 nPrefix,
		::xmloff::token::XMLTokenEnum eToken ) :
	XMLPersAttrListTContext( rImp, rQName, nPrefix, eToken )
{
}

XMLPersTextContentTContext::~XMLPersTextContentTContext()
{
}

void XMLPersTextContentTContext::Characters( const OUString& rChars )
{
	m_aCharacters += rChars;
}

void XMLPersTextContentTContext::ExportContent()
{
	GetTransformer().GetDocHandler()->characters( m_aCharacters );
}
