/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"
#include <com/sun/star/xml/sax/SAXParseException.hpp>
#include <com/sun/star/xml/sax/SAXException.hpp>
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#include <com/sun/star/xml/sax/XAttributeList.hpp>
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#include <xmloff/nmspmap.hxx>
#include <xmloff/xmltoken.hxx>
#include "xmloff/xmlnmspe.hxx"

#ifndef _XMLOFF_TRANSFOERMERBASE_HXX
#include "TransformerBase.hxx"
#endif
#include "MutableAttrList.hxx"

#ifndef _XMLOFF_METATCONTEXT_HXX
#include "DocumentTContext.hxx"
#endif

using ::rtl::OUString;

using namespace ::xmloff::token;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::beans;

TYPEINIT1( XMLDocumentTransformerContext, XMLTransformerContext );

XMLDocumentTransformerContext::XMLDocumentTransformerContext( XMLTransformerBase& rImp, 
							  				  const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName )
{
}

XMLDocumentTransformerContext::~XMLDocumentTransformerContext()
{
}

void XMLDocumentTransformerContext::StartElement( const Reference< XAttributeList >& rAttrList )
{
	Reference< XAttributeList > xAttrList( rAttrList );

	sal_Bool bMimeFound = sal_False;
	OUString aClass;
	OUString aClassQName(
					GetTransformer().GetNamespaceMap().GetQNameByKey(
								XML_NAMESPACE_OFFICE, GetXMLToken(XML_CLASS ) ) );

	XMLMutableAttributeList *pMutableAttrList = 0;
	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName, 
																 &aLocalName );
		if( XML_NAMESPACE_OFFICE == nPrefix &&
			IsXMLToken( aLocalName, XML_MIMETYPE ) )
		{
			const OUString& rValue = xAttrList->getValueByIndex( i );
			static const char * aTmp[] =
			{
				"application/vnd.oasis.openoffice.",
				"application/x-vnd.oasis.openoffice.",
				"application/vnd.oasis.opendocument.",
				"application/x-vnd.oasis.document.",
				NULL
			};
			for (int k=0; aTmp[k]; k++)
			{
				::rtl::OUString sTmpString = ::rtl::OUString::createFromAscii(aTmp[k]);
				if( rValue.matchAsciiL( aTmp[k], sTmpString.getLength() ) )
				{
					aClass = rValue.copy( sTmpString.getLength() );
					break;
				}
			}

			if( !pMutableAttrList )
			{
				pMutableAttrList = new XMLMutableAttributeList( xAttrList );
				xAttrList = pMutableAttrList;
			}
			pMutableAttrList->SetValueByIndex( i, aClass );
			pMutableAttrList->RenameAttributeByIndex(i, aClassQName );
			bMimeFound = sal_True;
			break;
		}
	}
	
	if( !bMimeFound )
	{
		const Reference< XPropertySet > rPropSet = 
			GetTransformer().GetPropertySet();

		if( rPropSet.is() )
		{
			Reference< XPropertySetInfo > xPropSetInfo(
				rPropSet->getPropertySetInfo() );
			OUString aPropName(RTL_CONSTASCII_USTRINGPARAM("Class"));
			if( xPropSetInfo.is() && xPropSetInfo->hasPropertyByName( aPropName ) )
			{
				Any aAny = rPropSet->getPropertyValue( aPropName );
				aAny >>= aClass;
			}
		}

		if( aClass.getLength() )
		{
			if( !pMutableAttrList )
			{
				pMutableAttrList = new XMLMutableAttributeList( xAttrList );
				xAttrList = pMutableAttrList;
			}

			pMutableAttrList->AddAttribute( aClassQName, aClass );
		}
	}
	XMLTransformerContext::StartElement( xAttrList );
}
