/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _XMLOFF_FORMS_VALUEPROPERTIES_HXX_
#define _XMLOFF_FORMS_VALUEPROPERTIES_HXX_

#include "controlelement.hxx"

//.........................................................................
namespace xmloff
{
//.........................................................................

	//=====================================================================
	//= OValuePropertiesMetaData
	//=====================================================================
	class OValuePropertiesMetaData
	{
	protected:
		OValuePropertiesMetaData() { }

	public:
		/** calculate the property names for the <em>current-value</em> and the <em>value</em> attribute.

			<p>If controls of the given FormComponentType do not have any of the properties requested,
			the respective out parameter will be set to NULL.</p>
		*/
		static void getValuePropertyNames(
			OControlElement::ElementType _eType,
			sal_Int16 _nFormComponentType,
			sal_Char const * & _rpCurrentValuePropertyName,
			sal_Char const * & _rpValuePropertyName);

		/** calculate the property names for the <em>min-value</em> and the <em>max-value</em> attribute.

			<p>If controls of the given FormComponentType do not have any of the properties requested,
			the respective out parameter will be set to NULL.</p>
		*/
		static void getValueLimitPropertyNames(
			sal_Int16 _nFormComponentType,
			sal_Char const * & _rpMinValuePropertyName,
			sal_Char const * & _rpMaxValuePropertyName);

		/** calculate the names of the properties which, at runtime, are used for <em>value</em> and
			<em>default value</em>.
		*/ 
		static void getRuntimeValuePropertyNames(
			OControlElement::ElementType _eType,
			sal_Int16 _nFormComponentType,
			sal_Char const * & _rpValuePropertyName,
			sal_Char const * & _rpDefaultValuePropertyName);
	};

//.........................................................................
}	// namespace xmloff
//.........................................................................

#endif // _XMLOFF_FORMS_VALUEPROPERTIES_HXX_


