/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



package org.openoffice.xmerge.converter.xml.sxc;


/**
 * Interface defining constants for Sxc attributes.
 *
 * @author	Martin Maher 
 */
public interface SxcConstants {

	/** Family name for column styles. */
	public static final String COLUMN_STYLE_FAMILY = "table-column";

	/** Family name for row styles. */
	public static final String ROW_STYLE_FAMILY = "table-row";

	/** Family name for table-cell styles. */
	public static final String TABLE_CELL_STYLE_FAMILY = "table-cell";

    /** Name of the default style. */
    public static final String DEFAULT_STYLE = "Default";	
}
