/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/

#ifndef __ACCDESCENDANTMANAGEREVENTLISTENER_HXX
#define __ACCDESCENDANTMANAGEREVENTLISTENER_HXX

#include <stdio.h>
#include "AccComponentEventListener.hxx"
#include <com/sun/star/accessibility/XAccessibleEventListener.hpp>
#include <com/sun/star/accessibility/XAccessible.hpp>

using namespace ::com::sun::star::uno;

/**
 * AccDescendantManagerEventListener is inherited from AccComponentEventListener. It handles 
 * the evnets generated by active descendant controls. They are: TREE, LIST, and TABLE. 
 * It defines the procedure of specific event handling related with active descendant components 
 * and provides the detailed support for some related methods. 
 */
class AccDescendantManagerEventListener: public AccComponentEventListener
{
protected:
    ::com::sun::star::accessibility::XAccessible* pActiveDescendant;
public:
    AccDescendantManagerEventListener(com::sun::star::accessibility::XAccessible* pAcc, AccObjectManagerAgent* Agent);
    virtual ~AccDescendantManagerEventListener();

    //AccessibleEventListener
    virtual void SAL_CALL notifyEvent( const ::com::sun::star::accessibility::AccessibleEventObject& aEvent ) throw (::com::sun::star::uno::RuntimeException);

    //for selection changed event
    virtual void SAL_CALL handleSelectionChangedEvent(Any oldValue, Any newValue);

    //for child changed event
    virtual void SAL_CALL handleChildChangedEvent (Any oldValue, Any newValue);

    virtual void SAL_CALL handleChildChangedNoFocusEvent(Any oldValue, Any newValue);

    bool NotifyChildEvent(short nWinEvent,const Any &Value);

    virtual void handleSelectionChangedAddEvent(const Any &oldValue, const Any &newValue);
    virtual void handleSelectionChangedRemoveEvent(const Any &oldValue, const Any &newValue);
    virtual void handleSelectionChangedWithinEvent(const Any &oldValue, const Any &newValue);
};

#endif
