/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/

#ifndef __ACCCONTAINEREVENTLISTENERHXX
#define __ACCCONTAINEREVENTLISTENERHXX

#include <stdio.h>
#include "AccEventListener.hxx"
#include <com/sun/star/accessibility/XAccessibleEventListener.hpp>
#include <com/sun/star/accessibility/XAccessible.hpp>

using namespace ::com::sun::star::uno;

/**
 * AccContainerEventListener is inherited from AccEventListener. It handles the evnets
 * generated by container controls. The accessible roles are: CANVAS, COMBO_BOX, DOCUMENT, 
 * EMBEDDED_OBJECT, END_NOTE, FILLER, FOOTNOTE, FOOTER, GRAPHIC, HEADER, LAYERED_PANE, 
 * MENU_BAR, POPUP_MENU, OPTION_PANE, PAGE_TAB, PAGE_TAB_LIST, PANEL, SCROLL_PANE, SPLIT_PANE, 
 * STATUS_BAR, TABLE_CELL, TEXT_FRAME, TOOL_BAR, VIEW_PORT.
 * It defines the procedure of specific event handling related with containsers and provides 
 * the detailed support for some related methods.  
 */
class AccContainerEventListener: public AccEventListener
{
public:
    AccContainerEventListener(com::sun::star::accessibility::XAccessible* pAcc, AccObjectManagerAgent* Agent);
    virtual ~AccContainerEventListener();

    //AccessibleEventListener
    virtual void SAL_CALL notifyEvent( const ::com::sun::star::accessibility::AccessibleEventObject& aEvent ) throw (::com::sun::star::uno::RuntimeException);

    //for child changed event
    virtual void SAL_CALL handleChildChangedEvent(Any oldValue, Any newValue);

    //for selection changed event
    virtual void SAL_CALL handleSelectionChangedEvent(const Any &oldValue, const Any &newValue);

    //for all children changed event
    virtual void SAL_CALL handleAllChildrenChangedEvent();

    //for text changed event
    virtual void SAL_CALL handleTextChangedEvent(Any oldValue, Any newValue);
    virtual void SAL_CALL handleStateChangedEvent(Any oldValue, Any newValue);

    //for visible data changed event
    virtual void SAL_CALL handleVisibleDataChangedEvent();

    //for bound rect changed event
    virtual void SAL_CALL handleBoundrectChangedEvent();

    //for value changed event
    virtual void SAL_CALL handleValueChangedEvent(Any oldValue, Any newValue);

    //state changed
    virtual void SAL_CALL setComponentState(short state, bool enable);
    virtual void SAL_CALL fireStatePropertyChange(short state, bool set
                                                     );
    virtual void SAL_CALL fireStateFocusdChange(bool enable);
    virtual bool SAL_CALL IsEditable(Reference<com::sun::star::accessibility::XAccessibleContext> xContext);

    // update all children's state
    void SAL_CALL UpdateAllChildrenState( com::sun::star::accessibility::XAccessible* pXAccessible );

    bool NotifyChildEvent(short nWinEvent,const Any &Value);

    virtual void handleSelectionChangedAddEvent(const Any &oldValue, const Any &newValue);
    virtual void handleSelectionChangedRemoveEvent(const Any &oldValue, const Any &newValue);
    virtual void handleSelectionChangedWithinEvent(const Any &oldValue, const Any &newValue);

    virtual void handlePageChangedEvent (const Any &oldValue, const Any &newValue);

    virtual void handleSectionChangedEvent (const Any &oldValue, const Any &newValue);
    virtual void handleColumnChangedEvent (const Any &oldValue, const Any &newValue);
	//for name changed event
    virtual void SAL_CALL handleNameChangedEvent(Any name);
};

#endif
