/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/

#ifndef __ACCCOMPONENTEVENTLISTENER_HXX
#define __ACCCOMPONENTEVENTLISTENER_HXX

#include <stdio.h>
#include "AccEventListener.hxx"
#include <com/sun/star/accessibility/XAccessibleEventListener.hpp>
#include <com/sun/star/accessibility/XAccessible.hpp>

using namespace ::com::sun::star::uno;
/**
 * AccComponentEventListener is inherited from AccEventListener. It handles the evnets
 * generated by component controls. The accessible roles are: CHECK_BOX, ICON, LABEL, 
 * MENU_ITEM, PUSH_BUTTON, RADIO_BUTTON, SCROLL_BAR, SEPARATOR, TOGGLE_BUTTON, TOOL_TIP, SPIN_BOX. 
 * It defines the procedure of specific event handling related with components and provides 
 * the detailed support for some related methods. 
 */
class AccComponentEventListener: public AccEventListener
{
private:
    static FILE *output, *output2, *output3, *outacc;//used for debugging
public:
    AccComponentEventListener(com::sun::star::accessibility::XAccessible* pAcc, AccObjectManagerAgent* Agent);
    virtual ~AccComponentEventListener();

    //AccessibleEventListener
    virtual void SAL_CALL notifyEvent( const ::com::sun::star::accessibility::AccessibleEventObject& aEvent ) throw (::com::sun::star::uno::RuntimeException);

    //for value changed event
    virtual void SAL_CALL handleValueChangedEvent(Any oldValue, Any newValue);

    //for action changed event
    virtual void SAL_CALL handleActionChangedEvent();

    //for text changed event
    virtual void SAL_CALL handleTextChangedEvent(Any oldValue, Any newValue);

    //for caret changed event
    virtual void SAL_CALL handleCaretChangedEvent(Any oldValue, Any newValue);

    //for visible data changed event
    virtual void SAL_CALL handleVisibleDataChangedEvent();

    //for bound rect changed event
    virtual void SAL_CALL handleBoundrectChangedEvent();

    virtual void SAL_CALL setComponentState(short state, bool enable);
    virtual void SAL_CALL fireStatePropertyChange(short state, bool set
                                                     );
    virtual void SAL_CALL fireStateFocusdChange(bool enable);

    void handleSelectionChangedEvent();

    //add TEXT_SELECTION_CHANGED event
    void handleTextSelectionChangedEvent();
};

#endif
