/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#include <childlist.hxx>

#include <libxml/tree.h>

#include <node.hxx>
#include <document.hxx>


namespace DOM
{
    CChildList::CChildList(::rtl::Reference<CNode> const& pBase,
                ::osl::Mutex & rMutex)
        : m_pNode(pBase)
        , m_rMutex(rMutex)
    {
    }

    /**
    The number of nodes in the list.
    */
    sal_Int32 SAL_CALL CChildList::getLength() throw (RuntimeException)
    {
        ::osl::MutexGuard const g(m_rMutex);

        sal_Int32 length = 0;
        if (m_pNode != NULL)
        {
            xmlNodePtr cur = m_pNode->GetNodePtr();
            if (0 != cur) {
                cur = cur->children;
            }
            while (cur != NULL)
            {
                length++;
                cur = cur->next;
            }
        }
        return length;

    }
    /**
    Returns the indexth item in the collection.
    */
    Reference< XNode > SAL_CALL CChildList::item(sal_Int32 index)
        throw (RuntimeException)
    {
        ::osl::MutexGuard const g(m_rMutex);

        if (m_pNode != NULL)
        {
            xmlNodePtr cur = m_pNode->GetNodePtr();
            if (0 != cur) {
                cur = cur->children;
            }
            while (cur != NULL)
            {
                if (index-- == 0) {
                    return Reference< XNode >(
                            m_pNode->GetOwnerDocument().GetCNode(cur).get());
                }
                cur = cur->next;
            }
        }
        return 0;
    }
}
