/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _CACHED_DYNAMIC_RESULTSET_STUB_HXX
#define _CACHED_DYNAMIC_RESULTSET_STUB_HXX

#include <dynamicresultsetwrapper.hxx>
#include <com/sun/star/ucb/XCachedDynamicResultSetStubFactory.hpp>

#define CACHED_DRS_STUB_SERVICE_NAME "com.sun.star.ucb.CachedDynamicResultSetStub"
#define CACHED_DRS_STUB_FACTORY_NAME "com.sun.star.ucb.CachedDynamicResultSetStubFactory"

//=========================================================================

class CachedDynamicResultSetStub
				: public DynamicResultSetWrapper
				, public com::sun::star::lang::XTypeProvider
				, public com::sun::star::lang::XServiceInfo
{
protected:
	virtual void SAL_CALL
	impl_InitResultSetOne( const com::sun::star::uno::Reference<
				com::sun::star::sdbc::XResultSet >& xResultSet );
	virtual void SAL_CALL
	impl_InitResultSetTwo( const com::sun::star::uno::Reference<
				com::sun::star::sdbc::XResultSet >& xResultSet );

public:
	CachedDynamicResultSetStub( com::sun::star::uno::Reference<
						com::sun::star::ucb::XDynamicResultSet > xOrigin
		, const com::sun::star::uno::Reference<
						com::sun::star::lang::XMultiServiceFactory > & xSMgr );

	virtual ~CachedDynamicResultSetStub();
	

	//-----------------------------------------------------------------
	// XInterface inherited
	//-----------------------------------------------------------------
	XINTERFACE_DECL()
	//-----------------------------------------------------------------
	// XTypeProvider
	//-----------------------------------------------------------------
	XTYPEPROVIDER_DECL()
	//-----------------------------------------------------------------
    // XServiceInfo
	//-----------------------------------------------------------------
	XSERVICEINFO_NOFACTORY_DECL()
};

//=========================================================================

class CachedDynamicResultSetStubFactory
				: public cppu::OWeakObject
				, public com::sun::star::lang::XTypeProvider
				, public com::sun::star::lang::XServiceInfo
				, public com::sun::star::ucb::XCachedDynamicResultSetStubFactory
{
protected:
	com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >	m_xSMgr;

public:

	CachedDynamicResultSetStubFactory(
		const com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory > & rSMgr);

	virtual ~CachedDynamicResultSetStubFactory();

	//-----------------------------------------------------------------
	// XInterface
	XINTERFACE_DECL()

	//-----------------------------------------------------------------
	// XTypeProvider
	XTYPEPROVIDER_DECL()

	//-----------------------------------------------------------------
    // XServiceInfo
	XSERVICEINFO_DECL()

	//-----------------------------------------------------------------
    // XCachedDynamicResultSetStubFactory

	virtual com::sun::star::uno::Reference<
		com::sun::star::ucb::XDynamicResultSet > SAL_CALL
	createCachedDynamicResultSetStub(
				const com::sun::star::uno::Reference<
					com::sun::star::ucb::XDynamicResultSet > & Source )
				throw( com::sun::star::uno::RuntimeException );


	virtual void SAL_CALL connectToCache(
				  const com::sun::star::uno::Reference<
						com::sun::star::ucb::XDynamicResultSet > & Source
				, const com::sun::star::uno::Reference<
						com::sun::star::ucb::XDynamicResultSet > & TargetCache
				, const com::sun::star::uno::Sequence<
						com::sun::star::ucb::NumberedSortingInfo > & SortingInfo
				, const com::sun::star::uno::Reference<
						com::sun::star::ucb::XAnyCompareFactory > & CompareFactory
				)
				throw (
				  com::sun::star::ucb::ListenerAlreadySetException
				, com::sun::star::ucb::AlreadyInitializedException
				, com::sun::star::uno::RuntimeException
				 );
};

#endif

