/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



package com.sun.star.wiki;

import javax.swing.text.html.*;
import javax.swing.text.MutableAttributeSet;

public class EditPageParser extends HTMLEditorKit.ParserCallback
{
    
    protected String m_sEditTime = "";
    protected String m_sEditToken = "";
    protected String m_sLoginToken = "";
    protected String m_sMainURL = "";

    private int m_nWikiArticleHash = 0;
    private boolean m_bHTMLStartFound = false;
    private boolean m_bInHead = false;

    protected int m_nWikiArticleStart = -1;
    protected int m_nWikiArticleEnd = -1;
    protected int m_nHTMLArticleStart = -1;
    protected int m_nHTMLArticleEnd = -1;
    protected int m_nNoArticleInd = -1;
    protected int m_nErrorInd = -1;
    
    /** Creates a new instance of WikiHTMLParser */
    public EditPageParser()
    {
    }
    
    public void handleComment( char[] data,int pos )
    {
        // insert code to handle comments
    }

    public void handleEndTag( HTML.Tag t,int pos )
    {
        if ( t == HTML.Tag.TEXTAREA )
        {
            m_nWikiArticleEnd = pos;
        }
        else if ( t == HTML.Tag.DIV )
        {
            if ( m_bHTMLStartFound )
            {
                m_nHTMLArticleStart = pos+6;
                m_bHTMLStartFound = false;
            }                
        }    
        else if ( t == HTML.Tag.HEAD )
        {
            m_bInHead = false;
        }
    }

    public void handleError( String errorMsg,int pos )
    {
        //System.out.println( errorMsg );
    }

    public void handleSimpleTag( HTML.Tag t, MutableAttributeSet a,int pos )
    {
        // insert code to handle simple tags

        if ( t == HTML.Tag.INPUT )
        {
            String sName = ( String ) a.getAttribute( HTML.Attribute.NAME );
            if ( sName != null )
            {
                if ( sName.equalsIgnoreCase( "wpEdittime" ) )
                {
                    this.m_sEditTime = ( String ) a.getAttribute( HTML.Attribute.VALUE );
                }
                else if ( sName.equalsIgnoreCase( "wpEditToken" ) )
                {
                    this.m_sEditToken = ( String ) a.getAttribute( HTML.Attribute.VALUE );
                }
                else if ( sName.equalsIgnoreCase( "wpLoginToken" ) )
                {
                    this.m_sLoginToken = ( String ) a.getAttribute( HTML.Attribute.VALUE );
                }
            }

        }
        else if ( t == HTML.Tag.LINK )
        {
            if ( m_bInHead )
            {
                String sName = ( String ) a.getAttribute( HTML.Attribute.HREF );
                if ( sName != null )
                {
                    int nIndexStart = sName.indexOf( "index.php" );
                    // get the main URL from the first header-link with index.php
                    // the link with "action=edit" inside is preferable
                    if ( nIndexStart>= 0
                      && ( m_sMainURL.length() == 0 || sName.indexOf( "action=edit" ) >= 0 ) )
                    {
                        m_sMainURL = sName.substring( 0, nIndexStart );
                    }
                }
            }
        }

    }

    public void handleStartTag( HTML.Tag t, MutableAttributeSet a,int pos )
    {
        // insert code to handle starting tags
        String sName = "";
        String sId = "";
        String sClass = "";

        if ( t == HTML.Tag.HEAD )
        {
            m_bInHead = true;
        }
        if ( t == HTML.Tag.TEXTAREA )
        {
            sName = ( String ) a.getAttribute( HTML.Attribute.NAME );
            if ( sName != null )
            {
                if ( sName.equalsIgnoreCase( "wpTextbox1" ) )
                {
                    m_nWikiArticleHash = t.hashCode();
                    m_nWikiArticleStart = pos;
                }                
            }
        }
        else if ( t == HTML.Tag.DIV )
        {
            sId = ( String ) a.getAttribute( HTML.Attribute.ID );
            sClass = ( String ) a.getAttribute( HTML.Attribute.CLASS );
            if ( sId != null )
            {
                if ( sId.equalsIgnoreCase( "contentSub" ) )
                {
                    m_bHTMLStartFound = true;
                }                
            }
            if ( sClass != null )
            {
                if ( sClass.equalsIgnoreCase( "printfooter" ) )
                {
                    m_nHTMLArticleEnd = pos;
                }
                else if ( sClass.equalsIgnoreCase( "noarticletext" ) )
                {
                    m_nNoArticleInd = pos;                    
                }
                else if ( sClass.equalsIgnoreCase( "errorbox" ) )
                {
                    m_nErrorInd = pos;
                }
            }
        }
        else if ( t == HTML.Tag.P )
        {
            sClass = ( String ) a.getAttribute( HTML.Attribute.CLASS );
            if ( sClass != null && sClass.equalsIgnoreCase( "error" ) )
            {
                m_nErrorInd = pos;
            }
        }   
    }

    
}
