/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"

// include ---------------------------------------------------------------


#include <svl/style.hxx>
#ifndef _MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#include <svl/stritem.hxx>
#include <sfx2/dispatch.hxx>
#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif

#include "wrtsh.hxx"
#include "view.hxx"
#include "swmodule.hxx"
#include "cmdid.h"
#include "docsh.hxx"
#include "tmplctrl.hxx"


// STATIC DATA -----------------------------------------------------------


SFX_IMPL_STATUSBAR_CONTROL( SwTemplateControl, SfxStringItem );

// class TemplatePopup_Impl --------------------------------------------------

class TemplatePopup_Impl : public PopupMenu
{
public:
	TemplatePopup_Impl();

	sal_uInt16			GetCurId() const { return nCurId; }

private:
	sal_uInt16			nCurId;

	virtual void    Select();
};

// -----------------------------------------------------------------------

TemplatePopup_Impl::TemplatePopup_Impl() :
	PopupMenu(),
	nCurId(USHRT_MAX)
{
}

// -----------------------------------------------------------------------

void TemplatePopup_Impl::Select()
{
	nCurId = GetCurItemId();
}

// class SvxZoomStatusBarControl ------------------------------------------

SwTemplateControl::SwTemplateControl( sal_uInt16 _nSlotId,
                                      sal_uInt16 _nId,
	                                  StatusBar& rStb ) :
    SfxStatusBarControl( _nSlotId, _nId, rStb )
{
}

// -----------------------------------------------------------------------

SwTemplateControl::~SwTemplateControl()
{
}

// -----------------------------------------------------------------------

void SwTemplateControl::StateChanged(
    sal_uInt16 /*nSID*/, SfxItemState eState, const SfxPoolItem* pState )
{
	if( eState != SFX_ITEM_AVAILABLE || pState->ISA( SfxVoidItem ) )
		GetStatusBar().SetItemText( GetId(), String() );
	else if ( pState->ISA( SfxStringItem ) )
	{
		sTemplate = ((SfxStringItem*)pState)->GetValue();
		GetStatusBar().SetItemText( GetId(), sTemplate );
	}
}

// -----------------------------------------------------------------------

void SwTemplateControl::Paint( const UserDrawEvent&  )
{
	GetStatusBar().SetItemText( GetId(), sTemplate );
}

// -----------------------------------------------------------------------

void SwTemplateControl::Command( const CommandEvent& rCEvt )
{
	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU &&
			GetStatusBar().GetItemText( GetId() ).Len() )
	{
		CaptureMouse();
		TemplatePopup_Impl aPop;
		{
			SwView* pView = ::GetActiveView();
			SwWrtShell* pWrtShell;
			if( pView && 0 != (pWrtShell = pView->GetWrtShellPtr()) &&
				!pWrtShell->SwCrsrShell::HasSelection()&&
				!pWrtShell->IsSelFrmMode() &&
				!pWrtShell->IsObjSelected())
			{
				SfxStyleSheetBasePool* pPool = pView->GetDocShell()->
															GetStyleSheetPool();
				pPool->SetSearchMask(SFX_STYLE_FAMILY_PAGE, SFXSTYLEBIT_ALL);
				if( pPool->Count() > 1 )
				{
					sal_uInt16 nCount = 0;
					SfxStyleSheetBase* pStyle = pPool->First();
					while( pStyle )
					{
						nCount++;
						aPop.InsertItem( nCount, pStyle->GetName() );
						pStyle = pPool->Next();
					}

					aPop.Execute( &GetStatusBar(), rCEvt.GetMousePosPixel());
                    sal_uInt16 nCurrId = aPop.GetCurId();
                    if( nCurrId != USHRT_MAX)
					{
						// sieht etwas umstaendlich aus, anders geht's aber nicht
                        pStyle = pPool->operator[]( nCurrId - 1 );
						SfxStringItem aStyle( FN_SET_PAGE_STYLE, pStyle->GetName() );
						pWrtShell->GetView().GetViewFrame()->GetDispatcher()->Execute(
									FN_SET_PAGE_STYLE,
									SFX_CALLMODE_SLOT|SFX_CALLMODE_RECORD,
									&aStyle, 0L );
					}
				}
			}
		}
		ReleaseMouse();
	}
}



