/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"




#include <sfx2/viewfrm.hxx>
#include <sfx2/dispatch.hxx>

#include "cmdid.h"
#include "swmodule.hxx"
#include "view.hxx"
#include "edtwin.hxx"
#include "label.hrc"

#define _SYNCDLG
#include "syncbtn.hxx"
#include "swtypes.hxx"

SFX_IMPL_FLOATINGWINDOW( SwSyncChildWin, FN_SYNC_LABELS )

/*------------------------------------------------------------------------
	Beschreibung:
------------------------------------------------------------------------*/

SwSyncChildWin::SwSyncChildWin( Window* _pParent,
								sal_uInt16 nId,
								SfxBindings* pBindings,
								SfxChildWinInfo* pInfo ) :
                                SfxChildWindow( _pParent, nId )
{
    pWindow = new SwSyncBtnDlg( pBindings, this, _pParent);

	if (!pInfo->aSize.Width() || !pInfo->aSize.Height())
	{
        SwView* pActiveView = ::GetActiveView();
        if(pActiveView)
        {
            const SwEditWin &rEditWin = pActiveView->GetEditWin();
            pWindow->SetPosPixel(rEditWin.OutputToScreenPixel(Point(0, 0)));
        }
        else
            pWindow->SetPosPixel(_pParent->OutputToScreenPixel(Point(0, 0)));
		pInfo->aPos = pWindow->GetPosPixel();
		pInfo->aSize = pWindow->GetSizePixel();
	}

	((SwSyncBtnDlg *)pWindow)->Initialize(pInfo);

	pWindow->Show();
}

/*------------------------------------------------------------------------
	Beschreibung:
------------------------------------------------------------------------*/

SwSyncBtnDlg::SwSyncBtnDlg( SfxBindings* _pBindings,
							SfxChildWindow* pChild,
							Window *pParent) :
    SfxFloatingWindow(_pBindings, pChild, pParent, SW_RES(DLG_SYNC_BTN)),
	aSyncBtn    	(this, SW_RES(BTN_SYNC ))
{
	FreeResource();
	aSyncBtn.SetClickHdl(LINK(this, SwSyncBtnDlg, BtnHdl));
}

/*------------------------------------------------------------------------
	Beschreibung:
------------------------------------------------------------------------*/

__EXPORT SwSyncBtnDlg::~SwSyncBtnDlg()
{
}

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

IMPL_LINK( SwSyncBtnDlg, BtnHdl, PushButton *, EMPTYARG )
{
	SfxViewFrame::Current()->GetDispatcher()->Execute(FN_UPDATE_ALL_LINKS, SFX_CALLMODE_ASYNCHRON);
	return 0;
}


