/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#include <pamtyp.hxx>


static SwMoveFnCollection aFwrd = {
	/* fnNd			*/  &GoNext,
	/* fnNds 		*/  &GoNextNds,
	/* fnDoc 		*/  &GoEndDoc,
	/* fnSections	*/  &GoEndSection,
	/* fnCmpOp		*/  &SwPosition::operator<,
	/* fnGetHint 	*/  &GetFrwrdTxtHint,
	/* fnSearch		*/  &utl::TextSearch::SearchFrwrd,
	/* fnSection 	*/  &SwNodes::GoStartOfSection
};

static SwMoveFnCollection aBwrd = {
	/* fnNd			*/  &GoPrevious,
	/* fnNds 		*/  &GoPreviousNds,
	/* fnDoc 		*/  &GoStartDoc,
	/* fnSections	*/  &GoStartSection,
	/* fnCmpOp		*/  &SwPosition::operator>,
	/* fnGetHint 	*/  &GetBkwrdTxtHint,
	/* fnSearch		*/  &utl::TextSearch::SearchBkwrd,
	/* fnSection 	*/  &SwNodes::GoEndOfSection
};

SwGoInDoc fnGoDoc 		= &GoInDoc;
SwGoInDoc fnGoSection	= &GoInSection;
SwGoInDoc fnGoNode		= &GoInNode;
SwGoInDoc fnGoCntnt		= &GoInCntnt;
SwGoInDoc fnGoCntntCells = &GoInCntntCells;
SwGoInDoc fnGoCntntSkipHidden      = &GoInCntntSkipHidden;
SwGoInDoc fnGoCntntCellsSkipHidden = &GoInCntntCellsSkipHidden;

SwWhichPara fnParaPrev	= &GoPrevPara;
SwWhichPara fnParaCurr	= &GoCurrPara;
SwWhichPara fnParaNext	= &GoNextPara;
SwPosPara fnParaStart	= &aFwrd;
SwPosPara fnParaEnd		= &aBwrd;

SwWhichSection fnSectionPrev	= &GoPrevSection;
SwWhichSection fnSectionCurr	= &GoCurrSection;
SwWhichSection fnSectionNext	= &GoNextSection;
SwPosSection fnSectionStart		= &aFwrd;
SwPosSection fnSectionEnd		= &aBwrd;

// Travelling in Tabellen
sal_Bool GotoPrevTable( SwPaM&, SwPosTable, sal_Bool bInReadOnly );
sal_Bool GotoCurrTable( SwPaM&, SwPosTable, sal_Bool bInReadOnly );
sal_Bool GotoNextTable( SwPaM&, SwPosTable, sal_Bool bInReadOnly );

SwWhichTable fnTablePrev = &GotoPrevTable;
SwWhichTable fnTableCurr = &GotoCurrTable;
SwWhichTable fnTableNext = &GotoNextTable;
SwPosTable fnTableStart = &aFwrd;
SwPosTable fnTableEnd = &aBwrd;

// Travelling in Bereichen
sal_Bool GotoPrevRegion( SwPaM&, SwPosRegion, sal_Bool bInReadOnly );
sal_Bool GotoCurrRegion( SwPaM&, SwPosRegion, sal_Bool bInReadOnly );
sal_Bool GotoCurrRegionAndSkip( SwPaM&, SwPosRegion, sal_Bool bInReadOnly );
sal_Bool GotoNextRegion( SwPaM&, SwPosRegion, sal_Bool bInReadOnly );

SwWhichRegion fnRegionPrev = &GotoPrevRegion;
SwWhichRegion fnRegionCurr = &GotoCurrRegion;
SwWhichRegion fnRegionCurrAndSkip = &GotoCurrRegionAndSkip;
SwWhichRegion fnRegionNext = &GotoNextRegion;
SwPosRegion fnRegionStart = &aFwrd;
SwPosRegion fnRegionEnd = &aBwrd;

SwMoveFn fnMoveBackward	= &aBwrd;
SwMoveFn fnMoveForward	= &aFwrd;

SwWhichPara GetfnParaCurr()
{
	return fnParaCurr;
}
SwPosPara GetfnParaStart()
{
	 return  fnParaStart;
}
SwWhichTable GetfnTablePrev()
{
    return fnTablePrev;
}
SwPosPara GetfnParaEnd()
{
	 return  fnParaEnd;
}
SwPosTable GetfnTableStart()
{
	return fnTableStart;
}
SwWhichTable GetfnTableCurr()
{
	return fnTableCurr;
}
SwPosTable GetfnTableEnd()
{
	return fnTableEnd;
}
