/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#include <doc.hxx>
#include <pamtyp.hxx>


sal_Bool SwPaM::Find( const SwFmt& rFmt, SwMoveFn fnMove,
						const SwPaM *pRegion, sal_Bool bInReadOnly  )
{
	sal_Bool bFound = sal_False;
	sal_Bool bSrchForward = fnMove == fnMoveForward;
	SwPaM* pPam = MakeRegion( fnMove, pRegion );

	// Wenn am Anfang/Ende, aus dem Node moven
	if( bSrchForward
		? pPam->GetPoint()->nContent.GetIndex() == pPam->GetCntntNode()->Len()
		: !pPam->GetPoint()->nContent.GetIndex() )
	{
		if( !(*fnMove->fnNds)( &pPam->GetPoint()->nNode, sal_False ))
		{
			delete pPam;
			return sal_False;
		}
		SwCntntNode *pNd = pPam->GetPoint()->nNode.GetNode().GetCntntNode();
		xub_StrLen nTmpPos = bSrchForward ? 0 : pNd->Len();
		pPam->GetPoint()->nContent.Assign( pNd, nTmpPos );
	}

	sal_Bool bFirst = sal_True;
	SwCntntNode* pNode;
	while( !bFound &&
			0 != ( pNode = ::GetNode( *pPam, bFirst, fnMove, bInReadOnly )))
	{
		if( 0 != ( bFound = pNode->GetFmtColl() == &rFmt ))
		{
			// wurde die FormatCollection gefunden, dann handelt es sich auf
			// jedenfall um einen SwCntntNode !!

			// FORWARD:  SPoint an das Ende, GetMark zum Anfanf vom Node
			// BACKWARD: SPoint zum Anfang,	GetMark an das Ende vom Node
			// und immer nach der Logik: inkl. Start, exkl. End !!!
			*GetPoint() = *pPam->GetPoint();
			SetMark();
			pNode->MakeEndIndex( &GetPoint()->nContent );
			GetMark()->nContent = 0;
			if( !bSrchForward )			// rueckwaerts Suche?
				Exchange(); 			// SPoint und GetMark tauschen
			break;
		}
	}
	delete pPam;
	return bFound;
}


