/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _ACCTEXTFRAME_HXX
#define _ACCTEXTFRAME_HXX
#include "accframebase.hxx"

#include <com/sun/star/accessibility/XAccessibleSelection.hpp>

class SwFlyFrm;
namespace utl { class AccessibleRelationSetHelper; }
namespace com { namespace star {
    namespace accessibility { struct AccessibleRelation; }
} }

class SwAccessibleTextFrame : public SwAccessibleFrameBase,
        public ::com::sun::star::accessibility::XAccessibleSelection 
{
private:
    // --> OD 2009-07-14 #i73249#
    ::rtl::OUString msTitle;
    ::rtl::OUString msDesc;
    // <--

protected:

	virtual ~SwAccessibleTextFrame();

	virtual void Modify( const SfxPoolItem* pOld, const SfxPoolItem *pNew);

public:

    SwAccessibleTextFrame( SwAccessibleMap* pInitMap, const SwFlyFrm* pFlyFrm );

	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface(
		::com::sun::star::uno::Type const & rType )
		throw (::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL acquire() throw ();
	virtual void SAL_CALL release() throw ();
	//=====  XAccessibleSelection  ============================================
	virtual void SAL_CALL selectAccessibleChild( 
		sal_Int32 nChildIndex ) 
		throw ( ::com::sun::star::lang::IndexOutOfBoundsException, 
		::com::sun::star::uno::RuntimeException );
	
	virtual sal_Bool SAL_CALL isAccessibleChildSelected( 
		sal_Int32 nChildIndex ) 
		throw ( ::com::sun::star::lang::IndexOutOfBoundsException, 
		::com::sun::star::uno::RuntimeException );
	
	virtual void SAL_CALL clearAccessibleSelection(  ) 
		throw ( ::com::sun::star::uno::RuntimeException );
	
	virtual void SAL_CALL selectAllAccessibleChildren(  ) 
		throw ( ::com::sun::star::uno::RuntimeException );
	
	virtual sal_Int32 SAL_CALL getSelectedAccessibleChildCount(  ) 
		throw ( ::com::sun::star::uno::RuntimeException );
	
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getSelectedAccessibleChild( 
		sal_Int32 nSelectedChildIndex ) 
		throw ( ::com::sun::star::lang::IndexOutOfBoundsException, 
		::com::sun::star::uno::RuntimeException);
	
	virtual void SAL_CALL deselectAccessibleChild( 
		sal_Int32 nSelectedChildIndex ) 
		throw ( ::com::sun::star::lang::IndexOutOfBoundsException, 
		::com::sun::star::uno::RuntimeException );

	//=====  XAccessibleContext  ==============================================

    // --> OD 2009-07-14 #i73249#
    /// Return the object's current name.
    virtual ::rtl::OUString SAL_CALL
        getAccessibleName (void)
        throw (::com::sun::star::uno::RuntimeException);
    // <--
    /// Return this object's description.
	virtual ::rtl::OUString SAL_CALL
    	getAccessibleDescription (void)
        throw (com::sun::star::uno::RuntimeException);

	//=====  XServiceInfo  ====================================================

    /**	Returns an identifier for the implementation of this object.
    */
	virtual ::rtl::OUString SAL_CALL
    	getImplementationName (void)
        throw (::com::sun::star::uno::RuntimeException);

    /**	Return whether the specified service is supported by this class.
    */
    virtual sal_Bool SAL_CALL
    	supportsService (const ::rtl::OUString& sServiceName)
        throw (::com::sun::star::uno::RuntimeException);

    /** Returns a list of all supported services.  In this case that is just
    	the AccessibleContext service.
    */
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString> SAL_CALL
    	getSupportedServiceNames (void)
        throw (::com::sun::star::uno::RuntimeException);

	//====== XTypeProvider ====================================================
    virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId(  ) throw(::com::sun::star::uno::RuntimeException);


    //=====  XAccessibleContext::getAccessibleRelationSet  ====================

    // text frame may have accessible relations to their
    // predocesor/successor frames

private:
    // helper methods for getAccessibleRelationSet:
    SwFlyFrm* getFlyFrm() const;

    com::sun::star::accessibility::AccessibleRelation makeRelation(
        sal_Int16 nType, const SwFlyFrm* pFrm );

public:

	virtual ::com::sun::star::uno::Reference<
            ::com::sun::star::accessibility::XAccessibleRelationSet> SAL_CALL
    	getAccessibleRelationSet (void)
        throw (::com::sun::star::uno::RuntimeException);
};


#endif
