/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _FMTFORDR_HXX
#define _FMTFORDR_HXX

#include <svl/eitem.hxx>
#include <hintids.hxx>
#include <format.hxx>

//Die FillOrder ---------------------------------

enum SwFillOrder
{
	SW_FILL_ORDER_BEGIN,
	ATT_TOP_DOWN = SW_FILL_ORDER_BEGIN,
	ATT_BOTTOM_UP,
	ATT_LEFT_TO_RIGHT,
	ATT_RIGHT_TO_LEFT,
	SW_FILL_ORDER_END
};

class SwFmtFillOrder: public SfxEnumItem
{
public:
	SwFmtFillOrder( SwFillOrder = ATT_TOP_DOWN );
	inline SwFmtFillOrder &operator=( const SwFmtFillOrder &rCpy );

	// "pure virtual Methoden" vom SfxPoolItem
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
	virtual sal_uInt16			GetValueCount() const;

	SwFillOrder GetFillOrder() const { return SwFillOrder(GetValue()); }
};

inline SwFmtFillOrder &SwFmtFillOrder::operator=( const SwFmtFillOrder &rCpy )
{
	SetValue( rCpy.GetValue() );
	return *this;
}

inline const SwFmtFillOrder &SwAttrSet::GetFillOrder(sal_Bool bInP) const
	{ return (const SwFmtFillOrder&)Get( RES_FILL_ORDER,bInP); }

inline const SwFmtFillOrder &SwFmt::GetFillOrder(sal_Bool bInP) const
	{ return aSet.GetFillOrder(bInP); }

#endif

