/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/properties/graphicproperties.hxx>
#include <svl/itemset.hxx>
#include <svl/style.hxx>
#include <svx/svddef.hxx>
#include <editeng/eeitem.hxx>
#include <svx/svdograf.hxx>
#include <svx/sdgcpitm.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		// create a new itemset
		SfxItemSet& GraphicProperties::CreateObjectSpecificItemSet(SfxItemPool& rPool)
		{
			return *(new SfxItemSet(rPool,

				// range from SdrAttrObj
				SDRATTR_START, SDRATTR_SHADOW_LAST,
				SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST,
				SDRATTR_TEXTDIRECTION, SDRATTR_TEXTDIRECTION,

				// range from SdrGrafObj
				SDRATTR_GRAF_FIRST, SDRATTR_GRAF_LAST,

				// range from SdrTextObj
				EE_ITEMS_START, EE_ITEMS_END,

				// end
				0, 0));
		}

		GraphicProperties::GraphicProperties(SdrObject& rObj)
		:	RectangleProperties(rObj)
		{
		}

		GraphicProperties::GraphicProperties(const GraphicProperties& rProps, SdrObject& rObj)
		:	RectangleProperties(rProps, rObj)
		{
		}

		GraphicProperties::~GraphicProperties()
		{
		}

		BaseProperties& GraphicProperties::Clone(SdrObject& rObj) const
		{
			return *(new GraphicProperties(*this, rObj));
		}

		void GraphicProperties::ItemSetChanged(const SfxItemSet& rSet)
		{
			SdrGrafObj& rObj = (SdrGrafObj&)GetSdrObject();

			// local changes
			rObj.SetXPolyDirty();

            // #i29367# Update GraphicAttr, too. This was formerly
            // triggered by SdrGrafObj::Notify, which is no longer
            // called nowadays. BTW: strictly speaking, the whole
            // ImpSetAttrToGrafInfo/ImpSetGrafInfoToAttr stuff could
            // be dumped, when SdrGrafObj::aGrafInfo is removed and
            // always created on the fly for repaint.
            rObj.ImpSetAttrToGrafInfo();

			// call parent
			RectangleProperties::ItemSetChanged(rSet);
		}

		void GraphicProperties::SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr)
		{
			SdrGrafObj& rObj = (SdrGrafObj&)GetSdrObject();

			// local changes
			rObj.SetXPolyDirty();

			// call parent
			RectangleProperties::SetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);

			// local changes
			rObj.ImpSetAttrToGrafInfo();
		}

		void GraphicProperties::ForceDefaultAttributes()
		{
			// call parent
			RectangleProperties::ForceDefaultAttributes();

			// force ItemSet
			GetObjectItemSet();

			mpItemSet->Put( SdrGrafLuminanceItem( 0 ) );
			mpItemSet->Put( SdrGrafContrastItem( 0 ) );
			mpItemSet->Put( SdrGrafRedItem( 0 ) );
			mpItemSet->Put( SdrGrafGreenItem( 0 ) );
			mpItemSet->Put( SdrGrafBlueItem( 0 ) );
			mpItemSet->Put( SdrGrafGamma100Item( 100 ) );
			mpItemSet->Put( SdrGrafTransparenceItem( 0 ) );
			mpItemSet->Put( SdrGrafInvertItem( sal_False ) );
			mpItemSet->Put( SdrGrafModeItem( GRAPHICDRAWMODE_STANDARD ) );
			mpItemSet->Put( SdrGrafCropItem( 0, 0, 0, 0 ) );
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
