/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/properties/e3dsphereproperties.hxx>
#include <svl/itemset.hxx>
#include <svx/sphere3d.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		E3dSphereProperties::E3dSphereProperties(SdrObject& rObj)
		:	E3dCompoundProperties(rObj)
		{
		}

		E3dSphereProperties::E3dSphereProperties(const E3dSphereProperties& rProps, SdrObject& rObj)
		:	E3dCompoundProperties(rProps, rObj)
		{
		}

		E3dSphereProperties::~E3dSphereProperties()
		{
		}

		BaseProperties& E3dSphereProperties::Clone(SdrObject& rObj) const
		{
			return *(new E3dSphereProperties(*this, rObj));
		}

		void E3dSphereProperties::PostItemChange(const sal_uInt16 nWhich)
		{
			// call parent
			E3dCompoundProperties::PostItemChange(nWhich);

			// handle value change
			E3dSphereObj& rObj = (E3dSphereObj&)GetSdrObject();

			switch(nWhich)
			{
				case SDRATTR_3DOBJ_HORZ_SEGS:
				{
					rObj.ActionChanged();
					break;
				}
				case SDRATTR_3DOBJ_VERT_SEGS:
				{
					rObj.ActionChanged();
					break;
				}
			}
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
