/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _SDR_PROPERTIES_E3DCOMPOUNDPROPERTIES_HXX
#define _SDR_PROPERTIES_E3DCOMPOUNDPROPERTIES_HXX

#include <svx/sdr/properties/e3dproperties.hxx>
#include "svx/svxdllapi.h"

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class SVX_DLLPUBLIC E3dCompoundProperties : public E3dProperties
		{
		protected:
			// Called after ItemChange() is done for all items.
			virtual void PostItemChange(const sal_uInt16 nWhich);

		public:
			// basic constructor
			E3dCompoundProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			E3dCompoundProperties(const E3dCompoundProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~E3dCompoundProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;

			// get itemset
			virtual const SfxItemSet& GetObjectItemSet() const;

			// Get merged ItemSet. Normally, this maps directly to GetObjectItemSet(), but may
			// be overloaded e.g for group objects to return a merged ItemSet of the object.
			// When using this method the returned ItemSet may contain items in the state
			// SFX_ITEM_DONTCARE which means there were several such items with different
			// values.
			virtual const SfxItemSet& GetMergedItemSet() const;

			// Set merged ItemSet. Normally, this maps to SetObjectItemSet().
			virtual void SetMergedItemSet(const SfxItemSet& rSet, sal_Bool bClearAllItems = sal_False);
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif // _SDR_PROPERTIES_E3DCOMPOUNDPROPERTIES_HXX

// eof
