/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _SDR_PROPERTIES_CUSTOMSHAPEPROPERTIES_HXX
#define _SDR_PROPERTIES_CUSTOMSHAPEPROPERTIES_HXX

#include <svx/sdr/properties/textproperties.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class CustomShapeProperties : public TextProperties
		{
        private:
			void UpdateTextFrameStatus(bool bInvalidateRenderGeometry);

		protected:
			// create a new itemset
			virtual SfxItemSet& CreateObjectSpecificItemSet(SfxItemPool& rPool);

			// test changeability for a single item
			virtual sal_Bool AllowItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem = 0) const;

			// react on ItemSet changes
			virtual void ItemSetChanged(const SfxItemSet& rSet);

			// react on Item change
			virtual void ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem);

			// Called after ItemChange() is done for all items. Allows local reactions on 
			// specific item changes
			virtual void PostItemChange(const sal_uInt16 nWhich);

			// clear single item
			virtual void ClearObjectItem(const sal_uInt16 nWhich = 0);

			// clear single item direct, do not do any notifies or things like that.
			// Also supports complete deleteion of items when default parameter 0 is used.
			virtual void ClearObjectItemDirect(const sal_uInt16 nWhich = 0);

		public:

			// set a new StyleSheet and broadcast
			virtual void SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr);

			// force default attributes for a specific object type, called from
			// DefaultProperties::GetObjectItemSet() if a new ItemSet is created
			virtual void ForceDefaultAttributes();

			// basic constructor
			CustomShapeProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			CustomShapeProperties(const CustomShapeProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~CustomShapeProperties();
			
			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;

			// This is the notifyer from SfxListener
			virtual void Notify(SfxBroadcaster& rBC, const SfxHint& rHint);
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_PROPERTIES_CUSTOMSHAPEPROPERTIES_HXX

// eof
