/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _SDR_CONTACT_VIEWCONTACTOFMASTERPAGEDESCRIPTOR_HXX
#define _SDR_CONTACT_VIEWCONTACTOFMASTERPAGEDESCRIPTOR_HXX

#include <sal/types.h>
#include <svx/sdr/contact/viewcontact.hxx>
#include <svx/sdrmasterpagedescriptor.hxx>

//////////////////////////////////////////////////////////////////////////////
// predeclarations
class SfxItemSet;
class Bitmap;
class MapMode;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		class ViewContactOfMasterPageDescriptor : public ViewContact
		{
		protected:
			// the owner of this ViewContact. Set from constructor and not
			// to be changed in any way.
			sdr::MasterPageDescriptor&						mrMasterPageDescriptor;

			// Create a Object-Specific ViewObjectContact
			virtual ViewObjectContact& CreateObjectSpecificViewObjectContact(ObjectContact& rObjectContact);

			// This method is responsible for creating the graphical visualisation data
			virtual drawinglayer::primitive2d::Primitive2DSequence createViewIndependentPrimitive2DSequence() const;

		public:
			// basic constructor
			ViewContactOfMasterPageDescriptor(sdr::MasterPageDescriptor& rDescriptor);

			// The destructor.
			virtual ~ViewContactOfMasterPageDescriptor();

			// access to MasterPageDescriptor
			sdr::MasterPageDescriptor& GetMasterPageDescriptor() const
			{
				return mrMasterPageDescriptor;
			}

			// Access to possible sub-hierarchy and parent
			virtual sal_uInt32 GetObjectCount() const;
			virtual ViewContact& GetViewContact(sal_uInt32 nIndex) const;
			virtual ViewContact* GetParentContact() const;
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VIEWCONTACTOFMASTERPAGEDESCRIPTOR_HXX

// eof
