/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SVX_HLNKITEM_HXX
#define _SVX_HLNKITEM_HXX

#include <tools/string.hxx>
#include <svl/poolitem.hxx>
#include <sfx2/sfxsids.hrc>
#include <svl/macitem.hxx>
#include "svx/svxdllapi.h"

#define HYPERDLG_EVENT_MOUSEOVER_OBJECT		0x0001
#define HYPERDLG_EVENT_MOUSECLICK_OBJECT	0x0002
#define HYPERDLG_EVENT_MOUSEOUT_OBJECT		0x0004

enum SvxLinkInsertMode
{
	HLINK_DEFAULT,
	HLINK_FIELD,
	HLINK_BUTTON,
	HLINK_HTMLMODE = 0x0080
};

class SVX_DLLPUBLIC SvxHyperlinkItem : public SfxPoolItem
{
	String sName;
	String sURL;
	String sTarget;
	SvxLinkInsertMode eType;

	String sIntName;
	SvxMacroTableDtor*	pMacroTable;

	sal_uInt16 nMacroEvents;

public:
	TYPEINFO();

	SvxHyperlinkItem( sal_uInt16 _nWhich = SID_HYPERLINK_GETLINK ):
				SfxPoolItem(_nWhich), pMacroTable(NULL)	{ eType = HLINK_DEFAULT; nMacroEvents=0; };
	SvxHyperlinkItem( const SvxHyperlinkItem& rHyperlinkItem );
	SvxHyperlinkItem( sal_uInt16 nWhich, String& rName, String& rURL,
								    String& rTarget, String& rIntName,
									SvxLinkInsertMode eTyp = HLINK_FIELD,
									sal_uInt16 nEvents = 0,
									SvxMacroTableDtor *pMacroTbl =NULL );
	virtual	~SvxHyperlinkItem () { delete pMacroTable; }

	inline SvxHyperlinkItem& operator=( const SvxHyperlinkItem &rItem );

	virtual int 			 operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	 Clone( SfxItemPool *pPool = 0 ) const;
	virtual	sal_Bool        	 QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
	virtual	sal_Bool			 PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

	const	String& GetName() const { return sName; }
	void	SetName(const String& rName) { sName = rName; }

	const	String& GetURL() const { return sURL; }
	void	SetURL(const String& rURL) { sURL = rURL; }

	const	String& GetIntName () const { return sIntName; }
	void	SetIntName(const String& rIntName) { sIntName = rIntName; }

	const	String& GetTargetFrame() const { return sTarget; }
	void	SetTargetFrame(const String& rTarget) { sTarget = rTarget; }

	SvxLinkInsertMode GetInsertMode() const { return eType; }
	void	SetInsertMode( SvxLinkInsertMode eNew ) { eType = eNew; }

	void SetMacro( sal_uInt16 nEvent, const SvxMacro& rMacro );

	void SetMacroTable( const SvxMacroTableDtor& rTbl );
	const SvxMacroTableDtor* GetMacroTbl() const	{ return pMacroTable; }

	void SetMacroEvents (const sal_uInt16 nEvents) { nMacroEvents = nEvents; }
	sal_uInt16 GetMacroEvents() const { return nMacroEvents; }

	virtual SvStream&			Store( SvStream &, sal_uInt16 nItemVersion ) const;
	virtual SfxPoolItem*		Create( SvStream &, sal_uInt16 nVer ) const;

};

#endif


