/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"

#include <com/sun/star/datatransfer/clipboard/XClipboardNotifier.hpp>

#include <vcl/svapp.hxx>
#include <vcl/window.hxx>
#include <vos/mutex.hxx>

#include <svtools/cliplistener.hxx>
#include <svtools/transfer.hxx>

using namespace ::com::sun::star;

// -----------------------------------------------------------------------------

TransferableClipboardListener::TransferableClipboardListener( const Link& rCallback ) :
	aLink( rCallback )
{
}

TransferableClipboardListener::~TransferableClipboardListener()
{
}

void SAL_CALL TransferableClipboardListener::disposing( const lang::EventObject& )
														throw(uno::RuntimeException)
{
}

void SAL_CALL TransferableClipboardListener::changedContents(
							const datatransfer::clipboard::ClipboardEvent& rEventObject )
														throw(uno::RuntimeException)
{
	if ( aLink.IsSet() )
	{
		const ::vos::OGuard aGuard( Application::GetSolarMutex() );

		TransferableDataHelper aDataHelper( rEventObject.Contents );
		aLink.Call( &aDataHelper );
	}
}

void TransferableClipboardListener::AddRemoveListener( Window* pWin, sal_Bool bAdd )
{
	try
	{
		if ( pWin )
		{
			uno::Reference<datatransfer::clipboard::XClipboard> xClipboard = pWin->GetClipboard();
			uno::Reference<datatransfer::clipboard::XClipboardNotifier> xClpbrdNtfr( xClipboard, uno::UNO_QUERY );
			if( xClpbrdNtfr.is() )
			{
				uno::Reference<datatransfer::clipboard::XClipboardListener> xClipEvtLstnr( this );
				if( bAdd )
					xClpbrdNtfr->addClipboardListener( xClipEvtLstnr );
				else
					xClpbrdNtfr->removeClipboardListener( xClipEvtLstnr );
			}
		}
	}
	catch( const ::com::sun::star::uno::Exception& )
	{
	}
}

void TransferableClipboardListener::ClearCallbackLink()
{
	aLink = Link();
}

