/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"
#include <svtools/fileurlbox.hxx>
#include <osl/file.h>
#include "svl/filenotation.hxx"

//.........................................................................
namespace svt
{
//.........................................................................

	//=====================================================================
	//= FileURLBox
	//=====================================================================
	//---------------------------------------------------------------------
	FileURLBox::FileURLBox(Window* _pParent)
		:SvtURLBox(_pParent, INET_PROT_FILE)
	{
		DisableHistory();
	}

	//---------------------------------------------------------------------
	FileURLBox::FileURLBox( Window* _pParent, WinBits _nStyle )
		:SvtURLBox( _pParent, _nStyle, INET_PROT_FILE )
	{
		DisableHistory();
	}

	//---------------------------------------------------------------------
	FileURLBox::FileURLBox(Window* _pParent, const ResId& _rId)
		:SvtURLBox(_pParent, _rId, INET_PROT_FILE)
	{
		DisableHistory();
	}

	//---------------------------------------------------------------------
    void FileURLBox::DisplayURL( const String& _rURL )
    {
        String sOldText = GetText();

        OFileNotation aTransformer( _rURL, OFileNotation::N_URL );
        String sNewText = aTransformer.get( OFileNotation::N_SYSTEM );
		SetText( sNewText );

        if ( sOldText != sNewText )
            Modify();

        UpdatePickList();
    }

	//---------------------------------------------------------------------
	long FileURLBox::PreNotify( NotifyEvent& _rNEvt )
	{
        switch ( _rNEvt.GetType() )
        {
        case EVENT_KEYINPUT:
		    if  (   ( GetSubEdit() == _rNEvt.GetWindow()                         )
                &&  ( KEY_RETURN == _rNEvt.GetKeyEvent()->GetKeyCode().GetCode() )
                &&  ( IsInDropDown()                                             )
                )
				m_sPreservedText = GetURL();
            break;

        case EVENT_LOSEFOCUS:
            if ( IsWindowOrChild( _rNEvt.GetWindow() ) )
                DisplayURL( GetText() );
            break;
        }

		return SvtURLBox::PreNotify(_rNEvt);
	}

	//---------------------------------------------------------------------
	long FileURLBox::Notify( NotifyEvent& _rNEvt )
	{
        switch ( _rNEvt.GetType() )
        {
        case EVENT_KEYINPUT:
    		if  (   ( GetSubEdit() == _rNEvt.GetWindow()                         )
                &&  ( KEY_RETURN == _rNEvt.GetKeyEvent()->GetKeyCode().GetCode() )
                &&  ( IsInDropDown()                                             )
                )
			{
				long nReturn = SvtURLBox::Notify(_rNEvt);
                DisplayURL( m_sPreservedText );
				return nReturn;
			}
            break;
        }

		return SvtURLBox::Notify(_rNEvt);
	}

//.........................................................................
}	// namespace svt
//.........................................................................

