/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SFXITEMITER_HXX
#define _SFXITEMITER_HXX

#include "svl/svldllapi.h"
#include <tools/solar.h>
#include <svl/itemset.hxx>

class SfxPoolItem;
class SfxItemSet;
class SfxItemPool;

class SVL_DLLPUBLIC SfxItemIter
{
	// Item-Feld - Start & Ende
	const SfxItemSet&	_rSet;
	sal_uInt16				_nStt, _nEnd, _nAkt;

public:
	SfxItemIter( const SfxItemSet& rSet );
	~SfxItemIter();

	// falls es diese gibt, returne sie, sonst 0
	const SfxPoolItem* FirstItem()
					   { _nAkt = _nStt;
						 return _rSet._nCount ? *(_rSet._aItems+_nAkt) : 0; }
	const SfxPoolItem* LastItem()
					   { _nAkt = _nEnd;
						 return _rSet._nCount ? *(_rSet._aItems+_nAkt) : 0; }
	const SfxPoolItem* GetCurItem()
					   { return _rSet._nCount ? *(_rSet._aItems+_nAkt) : 0; }
	const SfxPoolItem* NextItem();
	const SfxPoolItem* PrevItem();

	sal_Bool			   IsAtStart() const { return _nAkt == _nStt; }
	sal_Bool               IsAtEnd() const   { return _nAkt == _nEnd; }

	sal_uInt16             GetCurPos() const { return _nAkt; }
	sal_uInt16             GetFirstPos() const { return _nStt; }
	sal_uInt16             GetLastPos() const { return _nEnd; }
};

#endif
