/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _SVTOOLS_FSTATHELPER_HXX
#define _SVTOOLS_FSTATHELPER_HXX

#include "svl/svldllapi.h"
#include <tools/solar.h>

class UniString;
class Date;
class Time;

namespace FStatHelper {

/** Return the modified time and date stamp for this URL.

	@param URL	the asking URL

	@param pDate if unequal 0, the function set the date stamp

	@param pTime if unequal 0, the function set the time stamp

	@return 	it was be able to get the date/time stamp
*/
SVL_DLLPUBLIC sal_Bool GetModifiedDateTimeOfFile( const UniString& rURL,
									Date* pDate, Time* pTime );

/** Return if under the URL a document exist. This is only a wrapper for the
	UCB.IsContent.
*/
SVL_DLLPUBLIC sal_Bool IsDocument( const UniString& rURL );

/** Return if under the URL a folder exist. This is only a wrapper for the
	UCB.isFolder.
*/
SVL_DLLPUBLIC sal_Bool IsFolder( const UniString& rURL );

}

#endif
