/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SVTOOLS_CTLOPTIONS_HXX
#define _SVTOOLS_CTLOPTIONS_HXX

#include "svl/svldllapi.h"
#include <sal/types.h>
#include <svl/brdcst.hxx>
#include <svl/lstner.hxx>
#include <unotools/options.hxx>

class SvtCTLOptions_Impl;

// class SvtCTLOptions --------------------------------------------------------

class SVL_DLLPUBLIC SvtCTLOptions : public utl::detail::Options
{
private:
    SvtCTLOptions_Impl*    m_pImp;

public:

    // bDontLoad is for referencing purposes only
    SvtCTLOptions( sal_Bool bDontLoad = sal_False );
    virtual ~SvtCTLOptions();

    void            SetCTLFontEnabled( sal_Bool _bEnabled );
    sal_Bool		IsCTLFontEnabled() const;

    void			SetCTLSequenceChecking( sal_Bool _bEnabled );
    sal_Bool		IsCTLSequenceChecking() const;

	void			SetCTLSequenceCheckingRestricted( sal_Bool _bEnable );
	sal_Bool		IsCTLSequenceCheckingRestricted( void ) const;

    void            SetCTLSequenceCheckingTypeAndReplace( sal_Bool _bEnable );
    sal_Bool        IsCTLSequenceCheckingTypeAndReplace() const;

    enum CursorMovement
	{
		MOVEMENT_LOGICAL = 0,
		MOVEMENT_VISUAL
	};
    void        	SetCTLCursorMovement( CursorMovement _eMovement );
    CursorMovement	GetCTLCursorMovement() const;

	enum TextNumerals
	{
		NUMERALS_ARABIC = 0,
		NUMERALS_HINDI,
        NUMERALS_SYSTEM,
        NUMERALS_CONTEXT
	};
    void        	SetCTLTextNumerals( TextNumerals _eNumerals );
    TextNumerals	GetCTLTextNumerals() const;

    enum EOption
    {
        E_CTLFONT,
        E_CTLSEQUENCECHECKING,
        E_CTLCURSORMOVEMENT,
        E_CTLTEXTNUMERALS,
        E_CTLSEQUENCECHECKINGRESTRICTED,
        E_CTLSEQUENCECHECKINGTYPEANDREPLACE
    };
    sal_Bool IsReadOnly(EOption eOption) const;
};

#endif // _SVTOOLS_CTLOPTIONS_HXX

