#**************************************************************
#  
#  Licensed to the Apache Software Foundation (ASF) under one
#  or more contributor license agreements.  See the NOTICE file
#  distributed with this work for additional information
#  regarding copyright ownership.  The ASF licenses this file
#  to you under the Apache License, Version 2.0 (the
#  "License"); you may not use this file except in compliance
#  with the License.  You may obtain a copy of the License at
#  
#    http://www.apache.org/licenses/LICENSE-2.0
#  
#  Unless required by applicable law or agreed to in writing,
#  software distributed under the License is distributed on an
#  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
#  specific language governing permissions and limitations
#  under the License.
#  
#**************************************************************



package installer::windows::java;

use installer::exiter;
use installer::files;
use installer::globals;
use installer::windows::idtglobal;

####################################################################################
# Writing content into RegLocat.idt and AppSearc.idt to find Java on system
####################################################################################

sub update_java_tables
{
	my ($basedir, $allvariables) = @_;

	my $reglocatfile = "";
	my $appsearchfile = "";

	my $reglocatfilename = $basedir . $installer::globals::separator . "RegLocat.idt";
	my $appsearchfilename = $basedir . $installer::globals::separator . "AppSearc.idt";
	my $signaturefilename = $basedir . $installer::globals::separator . "Signatur.idt";
	
	if ( -f $reglocatfilename )
	{
		$reglocatfile = installer::files::read_file($reglocatfilename);
	}
	else
	{
		my @reglocattable = ();
		$reglocatfile = \@reglocattable;
		installer::windows::idtglobal::write_idt_header($reglocatfile, "reglocat");
	}

	if ( -f $appsearchfilename )
	{
		$appsearchfile = installer::files::read_file($appsearchfilename);
	}
	else
	{
		my @appsearchtable = ();
		$appsearchfile = \@appsearchtable;
		installer::windows::idtglobal::write_idt_header($appsearchfile, "appsearch");	
	}

	if ( -f $signaturefilename )
	{
		$signaturefile = installer::files::read_file($signaturefilename);
	}
	else
	{
		my @signaturetable = ();
		$signaturefile = \@signaturetable;
		installer::windows::idtglobal::write_idt_header($signaturefile, "signatur");	
	}

	# Writing content into this tables
	# Java version is saved in scp project
	# $installer::globals::javafile was defined in installer::windows::idtglobal::add_childprojects

	if ( ! $installer::globals::javafile->{'Javaversion'} ) { installer::exiter::exit_program("ERROR: \"Javaversion\" has to be defined in $installer::globals::javafile->{'gid'} in scp project!", "update_java_tables"); }
	
	my $javastring = $installer::globals::javafile->{'Javaversion'};
	
	my $signature = "JavaReg";
	my $rootvalue = "2";
	my $key = "Software\\JavaSoft\\Java Runtime Environment\\" . $javastring;
	my $name = "JavaHome";
	my $type = 2;
	my $property = "JAVAPATH";

	my $oneline = $signature . "\t" . $rootvalue . "\t" . $key . "\t" . $name . "\t" . $type . "\n";
	push(@{$reglocatfile}, $oneline);
		
	$oneline = $property . "\t" . $signature . "\n";
	push(@{$appsearchfile}, $oneline);

	# Saving the files
	
	installer::files::save_file($reglocatfilename ,$reglocatfile);
	my $infoline = "Updated idt file for Java: $reglocatfilename\n"; 
	$installer::logger::Lang->print($infoline);

	installer::files::save_file($appsearchfilename ,$appsearchfile);
	$infoline = "Updated idt file for Java: $appsearchfilename\n"; 
	$installer::logger::Lang->print($infoline);

	installer::files::save_file($signaturefilename ,$signaturefile);
	$infoline = "Updated idt file: $signaturefilename\n"; 
	$installer::logger::Lang->print($infoline);

}

1;
