#**************************************************************
#  
#  Licensed to the Apache Software Foundation (ASF) under one
#  or more contributor license agreements.  See the NOTICE file
#  distributed with this work for additional information
#  regarding copyright ownership.  The ASF licenses this file
#  to you under the Apache License, Version 2.0 (the
#  "License"); you may not use this file except in compliance
#  with the License.  You may obtain a copy of the License at
#  
#    http://www.apache.org/licenses/LICENSE-2.0
#  
#  Unless required by applicable law or agreed to in writing,
#  software distributed under the License is distributed on an
#  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
#  specific language governing permissions and limitations
#  under the License.
#  
#**************************************************************



package installer::pathanalyzer;

use installer::globals;

###########################################
# Path analyzer
###########################################

sub get_path_from_fullqualifiedname
{
	my ($longfilenameref) = @_;

	if ( $$longfilenameref =~ /\Q$installer::globals::separator\E/ )	# Is there a separator in the path? Otherwise the path is empty.
	{	
		if ( $$longfilenameref =~ /^\s*(\S.*\S\Q$installer::globals::separator\E)(\S.+\S?)/ )
		{
			$$longfilenameref = $1;
		}
	}
	else
	{
		$$longfilenameref = "";	# there is no path
	}	
}




=head2

    Despite its name, this function seems just to return the basename of the given filename.
    
=cut
sub make_absolute_filename_to_relative_filename
{
	my ($longfilenameref) = @_;
	
	if ( $installer::globals::isunix )
	{
		if ( $$longfilenameref =~ /^.*\/(\S.+\S?)/ )
		{
			$$longfilenameref = $1;
		}
	}

	if ( $installer::globals::iswin || $installer::globals::isos2 )
	{
		# Either '/' or '\'. It would be possible to use $installer::globals::separator.
		if ( $$longfilenameref =~ /^.*[\/\\](\S.+\S?)/ )
		{
			$$longfilenameref = $1;
		}
	}
}

1;
