/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef INCLUDED_SLIDESHOW_SLIDESHOWCONTEXT_HXX
#define INCLUDED_SLIDESHOW_SLIDESHOWCONTEXT_HXX

#include <com/sun/star/uno/Reference.hxx>
#include <boost/shared_ptr.hpp>

namespace com{ namespace sun{ namespace star{ namespace uno
{
    class XComponentContext;
}}}}


namespace slideshow
{
    namespace internal
    {
        class ShapeManager;
        class EventQueue;
        class ActivitiesQueue;
        class UserEventQueue;
        class EventMultiplexer;
        class ScreenUpdater;
        class UnoViewContainer;
        class CursorManager;
        class SubsettableShapeManager;

        /** Common arguments for slideshow objects.

        	This struct combines a number of object references
        	ubiquituously needed throughout the slideshow.
         */
		struct SlideShowContext
        {
            /** Common context for node creation

	            @param rShapeManager
                ShapeManager, which handles all shapes
                
                @param rEventQueue
                Event queue, where time-based events are to be
                scheduled. A node must not schedule events there
                before it's not resolved.
                
                @param rEventMultiplexer
                Event multiplexer. Clients can register there for
                about any event that happens in the slideshow
                
                @param rScreenUpdater
                Screen updater. Gets notified of necessary screen
                updates.

                @param rActivitiesQueue
                Activities queue, where repeating activities are
                to be scheduled.
                
                @param rUserEventQueue
                User event queue                

                @param rViewContainer
                Holds all views added to slideshow

                @param rComponentContext
                To create UNO services from
            */
            SlideShowContext( boost::shared_ptr<SubsettableShapeManager>&       rSubsettableShapeManager,
                              EventQueue&                                       rEventQueue,
                              EventMultiplexer&                                 rEventMultiplexer,
                              ScreenUpdater&                                    rScreenUpdater,
                              ActivitiesQueue&                                  rActivitiesQueue,
                              UserEventQueue&                                   rUserEventQueue,
                              CursorManager&                                    rCursorManager,
                              const UnoViewContainer&                           rViewContainer,
                              const ::com::sun::star::uno::Reference< 
                                  ::com::sun::star::uno::XComponentContext>&    rComponentContext );
            void dispose();

            boost::shared_ptr<SubsettableShapeManager>&     mpSubsettableShapeManager;
            EventQueue&										mrEventQueue;
            EventMultiplexer&								mrEventMultiplexer;
            ScreenUpdater&                                  mrScreenUpdater;
            ActivitiesQueue&								mrActivitiesQueue;
            UserEventQueue&									mrUserEventQueue;
            CursorManager&                                  mrCursorManager;
            const UnoViewContainer&                         mrViewContainer;
            ::com::sun::star::uno::Reference< 
                ::com::sun::star::uno::XComponentContext>	mxComponentContext;
        };
    }
}

#endif /* INCLUDED_SLIDESHOW_SLIDESHOWCONTEXT_HXX */
