/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_shell.hxx"

#if defined _MSC_VER
#pragma warning(push, 1)
#endif
#include <windows.h>
#if defined _MSC_VER
#pragma warning(pop)
#endif 

typedef HRESULT (__stdcall *lpfnDllRegisterServer)();
typedef HRESULT (__stdcall *lpfnDllUnregisterServer)();

/**
*/
bool IsUnregisterParameter(const char* Param)
{
	return ((0 == _stricmp(Param, "/u")) || 
			(0 == _stricmp(Param, "-u")));
}

/**	
*/
int main(int argc, char* argv[])
{
	HMODULE hmod;
	HRESULT hr = E_FAIL;
	lpfnDllRegisterServer   lpfn_register;
	lpfnDllUnregisterServer lpfn_unregister;

	if (2 == argc)
	{
		hmod = LoadLibraryA(argv[1]);
		
		if (hmod)
		{
			lpfn_register = (lpfnDllRegisterServer)GetProcAddress(
				hmod, "DllRegisterServer");

			if (lpfn_register)
				hr = lpfn_register();

			FreeLibrary(hmod);
		}
	}
	else if (3 == argc && IsUnregisterParameter(argv[1]))
	{
		hmod = LoadLibraryA(argv[2]);

		if (hmod)
		{
			lpfn_unregister = (lpfnDllUnregisterServer)GetProcAddress(
				hmod, "DllUnregisterServer");

			if (lpfn_unregister)
				hr = lpfn_unregister();

			FreeLibrary(hmod);
		}
	}

	return 0;
}
