/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sfx2.hxx"

//#define TF_NEWDESKTOP

#define _SDINTERN_HXX

#include <stdio.h>
#include <tools/urlobj.hxx>
#include <tools/config.hxx>
#include <svtools/ehdl.hxx>
#include <unotools/startoptions.hxx>
#include <svl/itempool.hxx>
#include <svl/urihelper.hxx>
#include <svtools/helpopt.hxx>
#include <vos/process.hxx>
#include <framework/sfxhelperfunctions.hxx>
#include <rtl/ustring.hxx>
#include <com/sun/star/uno/Exception.hpp>
#include <com/sun/star/uno/RuntimeException.hpp>
#include <com/sun/star/uno/Reference.hxx>

#include "sfxtypes.hxx"
#include "appdata.hxx"
#include <sfx2/docfac.hxx>
#include <sfx2/app.hxx>
#include "arrdecl.hxx"
#include <sfx2/dispatch.hxx>
#include "sfx2/sfxresid.hxx"
#include <sfx2/fcontnr.hxx>
#include <sfx2/viewsh.hxx>
#include "intro.hxx"
#include <sfx2/msgpool.hxx>
#include <sfx2/mnumgr.hxx>
#include <sfx2/appuno.hxx>
#include "app.hrc"
#include <sfx2/docfile.hxx>
#include "workwin.hxx"

#ifdef UNX
#define stricmp(a,b) strcmp(a,b)
#endif


//===================================================================

DBG_NAME(SfxAppMainNewMenu)
DBG_NAME(SfxAppMainBmkMenu)
DBG_NAME(SfxAppMainWizMenu)
DBG_NAME(SfxAppMainOLEReg)
DBG_NAME(SfxAppMainCHAOSReg)

//===================================================================

#define SFX_TEMPNAMEBASE_DIR	"soffice.tmp"
#define SFX_KEY_TEMPNAMEBASE	"Temp-Dir"

//===================================================================

#ifdef TF_POOLABLE
static SfxItemInfo __READONLY_DATA aItemInfos[] =
{
	{ 0, 0 }
};
#endif

//===================================================================

TYPEINIT2(SfxApplication,SfxShell,SfxBroadcaster);

//--------------------------------------------------------------------
void SfxApplication::Init
(
)

/*	[Beschreibung]

	Diese virtuelle Methode wird vom SFx aus Application:a:Main() gerufen,
	bevor Execute() ausgef"uhrt wird und
	- das Intro bereits angezeigt ist,
	- das Applikationsfenster exisitiert, aber noch hidden ist,
	- die Bindings bereits existieren (Controller sind anmeldbar),
	- der Ini- und Config-Manager bereits existiert,
	- die Standard-Controller bereits exisitieren,
	- die SFx-Shells ihre Interfaces bereits registriert haben.

	[Querverweise]
	<SfxApplication::Exit()>
	<SfxApplication::OpenClients()>
*/
{
}

//--------------------------------------------------------------------

void SfxApplication::Exit()

/*	[Beschreibung]

	Diese virtuelle Methode wird vom SFx aus Application::Main() gerufen,
	nachdem Execute() beendet ist und
	- die Konfiguration (SfxConfigManager) bereits gespeichert wurde,
	- die Fensterpostionen etc. in den SfxIniManager geschrieben wurden,
	- das Applikationsfenster noch existiert, aber hidden ist
	- s"amtliche Dokumente und deren Views bereits geschlossen sind.
	- Dispatcher, Bindings etc. bereits zerst"ort sind

	[Querverweise]
	<SfxApplication::Init(int,char*[])>
*/

{
}

//---------------------------------------------------------------------------

void SfxApplication::PreInit( )
{
}

void SfxApplication::Main( )
{
}

//-------------------------------------------------------------------------

SfxFilterMatcher& SfxApplication::GetFilterMatcher()
{
	if( !pAppData_Impl->pMatcher )
	{
		pAppData_Impl->pMatcher = new SfxFilterMatcher();
        URIHelper::SetMaybeFileHdl( STATIC_LINK(
			pAppData_Impl->pMatcher, SfxFilterMatcher, MaybeFileHdl_Impl ) );
	}
	return *pAppData_Impl->pMatcher;
}
