/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#define _WIN32_WINDOWS 0x0410
#ifdef _MSC_VER
#pragma warning(push, 1) /* disable warnings within system headers */
#endif
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <msiquery.h>
#ifdef _MSC_VER
#pragma warning(pop)
#endif

#include <malloc.h>

#ifdef UNICODE
#define _UNICODE
#define _tstring	wstring
#else
#define _tstring	string
#endif
#include <tchar.h>
#include <string>

#include <io.h>

static std::_tstring GetMsiProperty( MSIHANDLE handle, const std::_tstring& sProperty )
{
	std::_tstring	result;
	TCHAR	szDummy[1] = TEXT("");
	DWORD	nChars = 0;

	if ( MsiGetProperty( handle, sProperty.c_str(), szDummy, &nChars ) == ERROR_MORE_DATA )
	{
        DWORD nBytes = ++nChars * sizeof(TCHAR);
        LPTSTR buffer = reinterpret_cast<LPTSTR>(_alloca(nBytes));
        ZeroMemory( buffer, nBytes );
        MsiGetProperty(handle, sProperty.c_str(), buffer, &nChars);
        result = buffer;            
	}

	return	result;
}


static BOOL ExecuteCommand( LPCTSTR lpCommand, BOOL bSync )
{
	BOOL				fSuccess = FALSE;
	STARTUPINFO			si;
	PROCESS_INFORMATION	pi;

	ZeroMemory( &si, sizeof(si) );
	si.cb = sizeof(si);

	fSuccess = CreateProcess(
		NULL,
		(LPTSTR)lpCommand,
		NULL,
		NULL,
		FALSE,
		0,
		NULL,
		NULL,
		&si,
		&pi
		);

	if ( fSuccess )
	{
		if ( bSync )
			WaitForSingleObject( pi.hProcess, INFINITE );

		CloseHandle( pi.hProcess );
		CloseHandle( pi.hThread );
	}

	return fSuccess;
}

extern "C" UINT __stdcall ExecutePostUninstallScript( MSIHANDLE handle )
{
	TCHAR	szValue[8192];
	DWORD	nValueSize = sizeof(szValue);
	HKEY	hKey;
	std::_tstring	sInstDir;
	
	std::_tstring	sProductKey = GetMsiProperty( handle, TEXT("FINDPRODUCT") );

	// MessageBox( NULL, sProductKey.c_str(), "Titel", MB_OK );
	
	if ( ERROR_SUCCESS == RegOpenKey( HKEY_CURRENT_USER,  sProductKey.c_str(), &hKey ) )
	{
		if ( ERROR_SUCCESS == RegQueryValueEx( hKey, TEXT("INSTALLLOCATION"), NULL, NULL, (LPBYTE)szValue, &nValueSize ) )
		{
			sInstDir = szValue;
		}
		RegCloseKey( hKey );
	}
	else if ( ERROR_SUCCESS == RegOpenKey( HKEY_LOCAL_MACHINE,  sProductKey.c_str(), &hKey ) )
	{
		if ( ERROR_SUCCESS == RegQueryValueEx( hKey, TEXT("INSTALLLOCATION"), NULL, NULL, (LPBYTE)szValue, &nValueSize ) )
		{
			sInstDir = szValue;
		}
		RegCloseKey( hKey );
	}
	else
		return ERROR_SUCCESS;

	std::_tstring	sInfFile = sInstDir + TEXT("program\\postuninstall.inf");
	std::_tstring	sCommand = _T("RUNDLL32.EXE ");

	// MessageBox( NULL, sInfFile.c_str(), "Titel", MB_OK );
	
	if ( (LONG)GetVersion() < 0 )
		sCommand += _T("setupx.dll");
	else
		sCommand += _T("setupapi.dll");

	sCommand += _T(",InstallHinfSection PostUninstall 132 ");
	sCommand += sInfFile;

	if ( 0 == _taccess( sInfFile.c_str(), 2 ) )
		ExecuteCommand( sCommand.c_str(), TRUE );

	DeleteFile( sInfFile.c_str() );

	return ERROR_SUCCESS;
}

