/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include "zoomlist.hxx"

#ifndef _SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#include <sfx2/bindings.hxx>
#include <sfx2/viewfrm.hxx>
#ifndef _SFXVIEWSHELL_HXX
#include <sfx2/viewsh.hxx>
#endif


#include "ViewShell.hxx"

namespace sd {

#define MAX_ENTRYS	10

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

ZoomList::ZoomList(ViewShell* pViewShell)
: List()
, mpViewShell (pViewShell)
, mnCurPos(0)
{
}


/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

ZoomList::~ZoomList()
{
#if ( defined GCC && defined C272 )
	for (sal_uLong nObject=0; nObject<List::Count(); nObject++)
#else
	for (sal_uLong nObject=0; nObject<Count(); nObject++)
#endif
	{
		// Ggf. ZoomRects loeschen
		delete ((Rectangle*) GetObject(nObject));
	}
}


/*************************************************************************
|*
|* Neues ZoomRect aufnehmen
|*
\************************************************************************/

void ZoomList::InsertZoomRect(const Rectangle& rRect)
{
	sal_uLong nRectCount = Count();

	if (nRectCount >= MAX_ENTRYS)
	{
		delete ((Rectangle*) GetObject(0));
		Remove((sal_uLong) 0);
	}
	else if (nRectCount == 0)
	{
		mnCurPos = 0;
	}
	else
	{
		mnCurPos++;
	}

	Rectangle* pRect = new Rectangle(rRect);
	Insert(pRect, mnCurPos);

	SfxBindings& rBindings = mpViewShell->GetViewFrame()->GetBindings();
	rBindings.Invalidate( SID_ZOOM_NEXT );
	rBindings.Invalidate( SID_ZOOM_PREV );
}

/*************************************************************************
|*
|* Naechstes ZoomRect herausgeben
|*
\************************************************************************/

Rectangle ZoomList::GetNextZoomRect()
{
	mnCurPos++;
	sal_uLong nRectCount = Count();

	if (nRectCount > 0 && mnCurPos > nRectCount - 1)
	{
		mnCurPos = nRectCount - 1;
	}

	SfxBindings& rBindings = mpViewShell->GetViewFrame()->GetBindings();
	rBindings.Invalidate( SID_ZOOM_NEXT );
	rBindings.Invalidate( SID_ZOOM_PREV );

	Rectangle aRect(*(Rectangle*) GetObject(mnCurPos));
	return (aRect);
}

/*************************************************************************
|*
|* Letztes ZoomRect herausgeben
|*
\************************************************************************/

Rectangle ZoomList::GetPreviousZoomRect()
{
	if (mnCurPos > 0)
	{
		mnCurPos--;
	}

	SfxBindings& rBindings = mpViewShell->GetViewFrame()->GetBindings();
	rBindings.Invalidate( SID_ZOOM_NEXT );
	rBindings.Invalidate( SID_ZOOM_PREV );

	Rectangle aRect(*(Rectangle*) GetObject(mnCurPos));
	return (aRect);
}

/*************************************************************************
|*
|* Gibt es ein naechstes ZoomRect?
|*
\************************************************************************/

sal_Bool ZoomList::IsNextPossible() const
{
	sal_Bool bPossible = sal_False;
	sal_uLong nRectCount = Count();

	if (nRectCount > 0 && mnCurPos < nRectCount - 1)
	{
		bPossible = sal_True;
	}

	return (bPossible);
}

/*************************************************************************
|*
|* Gibt es ein vorheriges ZoomRect?
|*
\************************************************************************/

sal_Bool ZoomList::IsPreviousPossible() const
{
	sal_Bool bPossible = sal_False;

	if (mnCurPos > 0)
	{
		bPossible = sal_True;
	}

	return (bPossible);
}

} // end of namespace sd
