/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _SD_INSPAGOB_HXX
#define _SD_INSPAGOB_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#include <vcl/dialog.hxx>
#include "sdtreelb.hxx"

class SdDrawDocument;

//------------------------------------------------------------------------

class SdInsertPagesObjsDlg : public ModalDialog
{
private:
	SdPageObjsTLB			aLbTree;
	CheckBox				aCbxLink;
	CheckBox				aCbxMasters;
	OKButton				aBtnOk;
	CancelButton			aBtnCancel;
	HelpButton				aBtnHelp;

	SfxMedium*				pMedium;
	const SdDrawDocument*	mpDoc;
	const String&			rName;

	void					Reset();
	DECL_LINK( SelectObjectHdl, void * );

public:
				SdInsertPagesObjsDlg( Window* pParent,
								const SdDrawDocument* pDoc,
								SfxMedium* pSfxMedium,
								const String& rFileName );
				~SdInsertPagesObjsDlg();

	List*   	GetList( sal_uInt16 nType );
	sal_Bool		IsLink();
	sal_Bool 		IsRemoveUnnessesaryMasterPages() const;
};


#endif // _SD_INSPAGOB_HXX
