/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef SD_SLIDESORTER_SLIDE_SORTER_VIEW_SHELL_HXX
#define SD_SLIDESORTER_SLIDE_SORTER_VIEW_SHELL_HXX

#include "ViewShell.hxx"
#include "glob.hxx"
#include <sfx2/shell.hxx>
#include <sfx2/viewfac.hxx>
#include <boost/shared_ptr.hpp>
#include <vector>

namespace sd { namespace slidesorter { namespace controller {
class SlotManager;
} } }


namespace sd { namespace slidesorter {

class SlideSorter;

class SlideSorterViewShell
    : public ViewShell
{
    friend class controller::SlotManager;

public:
    TYPEINFO();
    SFX_DECL_INTERFACE(SD_IF_SDSLIDESORTERVIEWSHELL)

    static ::boost::shared_ptr<SlideSorterViewShell> Create(
        SfxViewFrame* pFrame, 
        ViewShellBase& rViewShellBase,
        ::Window* pParentWindow,
        FrameView* pFrameView,
        const bool bIsCenterPane);

    virtual ~SlideSorterViewShell (void);

    /** Late initialization that has to be called after a new instance has
        completed its construction.
    */
    virtual void Init (bool bIsMainViewShell);

    /** Return a slide sorter that is currently displayed in one of the
        panes that belong to the given ViewShellBase object.
        When there is only one slide sorter visible then that one is
        returned.  When two (or more) are visible then the one in the center
        pane is returned.  When no slidesorter is visible then NULL is
        returned.
    */
    static SlideSorterViewShell* GetSlideSorter (ViewShellBase& rBase);

    virtual void GetFocus (void);
    virtual void LoseFocus (void);
    virtual SdPage*	GetActualPage (void);

	/// inherited from sd::ViewShell
	virtual SdPage* getCurrentPage() const; 

	void ExecCtrl (SfxRequest& rRequest);
	virtual void GetCtrlState (SfxItemSet &rSet);
	virtual void FuSupport (SfxRequest& rRequest);
	virtual void FuTemporary (SfxRequest& rRequest);
	virtual void GetStatusBarState (SfxItemSet& rSet);
	virtual void FuPermanent (SfxRequest& rRequest);
	void GetAttrState (SfxItemSet& rSet);
	void ExecStatusBar (SfxRequest& rRequest);
    virtual void Command (const CommandEvent& rEvent, ::sd::Window* pWindow);
	virtual void GetMenuState (SfxItemSet &rSet);
	virtual void GetClipboardState (SfxItemSet &rSet);

	virtual void ReadFrameViewData (FrameView* pView);
	virtual void WriteFrameViewData (void);

    /** Set the zoom factor.  The given value is clipped against an upper
        bound.
        @param nZoom
            An integer percent value, i.e. nZoom/100 is the actual zoom
            factor.
        */
	virtual void SetZoom (long int nZoom);
	virtual void SetZoomRect (const Rectangle& rZoomRect);

    /** This is a callback method used by the active window to delegate its
        Paint() call to.  This view shell itself delegates it to the view.
    */
	virtual void Paint(const Rectangle& rRect, ::sd::Window* pWin);

    /** Place and size the controls and windows.  You may want to call this
        method when something has changed that for instance affects the
        visibility state of the scroll bars.
    */
    virtual void ArrangeGUIElements (void);

	virtual void Activate (sal_Bool IsMDIActivate);
	virtual void Deactivate (sal_Bool IsMDIActivate);

    //===== Drag and Drop =====================================================

    virtual void StartDrag (
        const Point& rDragPt,
        ::Window* pWindow );
	virtual void DragFinished (
        sal_Int8 nDropAction);
    virtual sal_Int8 AcceptDrop (
        const AcceptDropEvent& rEvt,
        DropTargetHelper& rTargetHelper, 
        ::sd::Window* pTargetWindow = NULL, 
        sal_uInt16 nPage = SDRPAGE_NOTFOUND, 
        sal_uInt16 nLayer = SDRPAGE_NOTFOUND );
	virtual sal_Int8 ExecuteDrop (
        const ExecuteDropEvent& rEvt, 
        DropTargetHelper& rTargetHelper,
        ::sd::Window* pTargetWindow = NULL, 
        sal_uInt16 nPage = SDRPAGE_NOTFOUND, 
        sal_uInt16 nLayer = SDRPAGE_NOTFOUND);

    typedef ::std::vector<SdPage*> PageSelection;

    /** Return the set of selected pages.
    */
    ::boost::shared_ptr<PageSelection> GetPageSelection (void) const;

    void SetPageSelection (const ::boost::shared_ptr<PageSelection>& rSelection);

    /** Add a listener that is called when the selection of the slide sorter
        changes.
        @param rListener
            When this method is called multiple times for the same listener
            the second and all following calls are ignored.  Each listener
            is added only once.
    */
    void AddSelectionChangeListener (const Link& rListener);

    /** Remove a listener that was called when the selection of the slide
        sorter changes.
        @param rListener
            It is save to pass a listener that was not added are has been
            removed previously.  Such calls are ignored.
    */
    void RemoveSelectionChangeListener (const Link& rListener);

    virtual css::uno::Reference<css::drawing::XDrawSubController> CreateSubController (void);

    /** Create an accessible object representing the specified window.
	    @param pWindow
	        The returned object makes the document displayed in this window
	        accessible.
        @return
	        Returns an <type>AccessibleSlideSorterView</type> object.
   */
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible>
        CreateAccessibleDocumentView (::sd::Window* pWindow);
	// handle SlideSorterView specially because AccessibleSlideSorterView doesn't inherit from AccessibleDocumentViewBase
	virtual void SwitchViewFireFocus( ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > xAcc );

    SlideSorter& GetSlideSorter (void) const;

    /** Try to relocate all toplevel window elements to the given parent
        window.
    */
    virtual bool RelocateToParentWindow (::Window* pParentWindow);

protected:

    virtual SvBorder GetBorder (bool bOuterResize);

    /** This method is overloaded to handle a missing tool bar correctly.
        This is the case when the slide sorter is not the main view shell.
    */
    virtual ::svl::IUndoManager* ImpGetUndoManager (void) const;

private:
    ::boost::shared_ptr<SlideSorter> mpSlideSorter;
    bool mbIsArrangeGUIElementsPending;
    
    SlideSorterViewShell (
        SfxViewFrame* pFrame, 
        ViewShellBase& rViewShellBase,
        ::Window* pParentWindow,
        FrameView* pFrameView);
    void Initialize (void);

    /** This method overwrites the one from our base class:  We do our own
        scroll bar and the base class call is thus unnecessary.  It simply
        calls UpdateScrollBars(false).
    */
    virtual void UpdateScrollBars (void);
};

typedef ::boost::shared_ptr<SlideSorterViewShell::PageSelection> SharedPageSelection;

} } // end of namespace ::sd::slidesorter

#endif
