/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"



#include "fudspord.hxx"

#include <svx/svxids.hrc>
#include <vcl/pointr.hxx>

#include "app.hrc"
#include "fupoor.hxx"
#include "ViewShell.hxx"
#include "View.hxx"
#ifndef SD_WINDOW_SHELL_HXX
#include "Window.hxx"
#endif
#include "drawdoc.hxx"

namespace sd {

TYPEINIT1( FuDisplayOrder, FuPoor );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuDisplayOrder::FuDisplayOrder( ViewShell* pViewSh, ::sd::Window* pWin, ::sd::View* pView, SdDrawDocument* pDoc, SfxRequest& rReq) 
: FuPoor(pViewSh, pWin, pView, pDoc, rReq)
, mpRefObj(NULL)
, mpOverlay(0L)
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

FuDisplayOrder::~FuDisplayOrder()
{
	implClearOverlay();
}

void FuDisplayOrder::implClearOverlay()
{
	if(mpOverlay)
	{
		delete mpOverlay;
		mpOverlay = 0L;
	}
}

FunctionReference FuDisplayOrder::Create( ViewShell* pViewSh, ::sd::Window* pWin, ::sd::View* pView, SdDrawDocument* pDoc, SfxRequest& rReq )
{
	FunctionReference xFunc( new FuDisplayOrder( pViewSh, pWin, pView, pDoc, rReq ) );
	return xFunc;
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

sal_Bool FuDisplayOrder::MouseButtonDown(const MouseEvent& rMEvt)
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	return sal_True;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

sal_Bool FuDisplayOrder::MouseMove(const MouseEvent& rMEvt)
{
	SdrObject* pPickObj;
	SdrPageView* pPV;
	Point aPnt( mpWindow->PixelToLogic( rMEvt.GetPosPixel() ) );

	if ( mpView->PickObj(aPnt, mpView->getHitTolLog(), pPickObj, pPV) )
	{
		if (mpRefObj != pPickObj)
		{
			// delete current overlay
			implClearOverlay();

			// create new one
			mpOverlay = new SdrDropMarkerOverlay(*mpView, *pPickObj);

			// remember referenced object
			mpRefObj = pPickObj;
		}
	}
	else
	{
		mpRefObj = NULL;
		implClearOverlay();
	}

	return sal_True;
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

sal_Bool FuDisplayOrder::MouseButtonUp(const MouseEvent& rMEvt)
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	SdrPageView* pPV = NULL;
	Point aPnt( mpWindow->PixelToLogic( rMEvt.GetPosPixel() ) );

	if ( mpView->PickObj(aPnt, mpView->getHitTolLog(), mpRefObj, pPV) )
	{
		if (nSlotId == SID_BEFORE_OBJ)
		{
			mpView->PutMarkedInFrontOfObj(mpRefObj);
		}
		else
		{
			mpView->PutMarkedBehindObj(mpRefObj);
		}
	}

	mpViewShell->Cancel();

	return sal_True;
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void FuDisplayOrder::Activate()
{
	maPtr = mpWindow->GetPointer();
	mpWindow->SetPointer( Pointer( POINTER_REFHAND ) );
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void FuDisplayOrder::Deactivate()
{
	mpWindow->SetPointer( maPtr );
}


} // end of namespace sd
