/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"
#include <com/sun/star/presentation/ParagraphTarget.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/presentation/EffectNodeType.hpp>
#include <comphelper/processfactory.hxx>
#include <vos/mutex.hxx>
#include <editeng/outliner.hxx>
#include "CustomAnimationCloner.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include <CustomAnimationPreset.hxx>
#include <TransitionPreset.hxx>
#include "undoanim.hxx"
#include "EffectMigration.hxx"

using namespace ::vos;
using ::rtl::OUString;
using namespace ::sd;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::animations;
using namespace ::com::sun::star::presentation;

using ::com::sun::star::drawing::XShape;

/** returns a helper class to manipulate effects inside the main sequence */
sd::MainSequencePtr SdPage::getMainSequence()
{
	if( 0 == mpMainSequence.get() )
		mpMainSequence.reset( new sd::MainSequence( getAnimationNode() ) );

	return mpMainSequence;
}

/** returns the main animation node */
Reference< XAnimationNode > SdPage::getAnimationNode() throw (RuntimeException)
{
	if( !mxAnimationNode.is() )
	{
		mxAnimationNode = Reference< XAnimationNode >::query(::comphelper::getProcessServiceFactory()->createInstance(OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.animations.ParallelTimeContainer"))));
		if( mxAnimationNode.is() )
		{
			Sequence< ::com::sun::star::beans::NamedValue > aUserData( 1 );
			aUserData[0].Name = OUString( RTL_CONSTASCII_USTRINGPARAM( "node-type" ) );
			aUserData[0].Value <<= ::com::sun::star::presentation::EffectNodeType::TIMING_ROOT;
			mxAnimationNode->setUserData( aUserData );
		}
	}

	return mxAnimationNode;
}

void SdPage::setAnimationNode( Reference< XAnimationNode >& xNode ) throw (RuntimeException)
{
	mxAnimationNode = xNode;
	if( mpMainSequence.get() )
		mpMainSequence->reset( xNode );
}

/** removes all custom animations for the given shape */
void SdPage::removeAnimations( const SdrObject* pObj )
{
	if( mxAnimationNode.is() )
	{
		getMainSequence();

		Reference< XShape > xShape( const_cast<SdrObject*>(pObj)->getUnoShape(), UNO_QUERY );

		if( mpMainSequence->hasEffect( xShape ) )
			mpMainSequence->disposeShape( xShape );
	}
}

bool SdPage::hasAnimationNode() const
{
	return mxAnimationNode.is();
}

void SdPage::SetFadeEffect(::com::sun::star::presentation::FadeEffect eNewEffect)
{
	EffectMigration::SetFadeEffect( this, eNewEffect );
}

FadeEffect SdPage::GetFadeEffect() const
{
	return EffectMigration::GetFadeEffect( this );
}

/** callback from the sd::View when a new paragraph for one object on this page is created */
void SdPage::onParagraphInserted( ::Outliner* pOutliner, Paragraph* pPara, SdrObject* pObj )
{
	if( mxAnimationNode.is() )
	{
		ParagraphTarget aTarget;
		aTarget.Shape = Reference< XShape >( pObj->getUnoShape(), UNO_QUERY );
		aTarget.Paragraph = (sal_Int16)pOutliner->GetAbsPos( pPara );

		getMainSequence()->insertTextRange( makeAny( aTarget ) );
	}
}

/** callback from the sd::View when a paragraph from one object on this page is removed */
void SdPage::onParagraphRemoving( ::Outliner* pOutliner, Paragraph* pPara, SdrObject* pObj )
{
	if( mxAnimationNode.is() )
	{
		ParagraphTarget aTarget;
		aTarget.Shape = Reference< XShape >( pObj->getUnoShape(), UNO_QUERY );
		aTarget.Paragraph = (sal_Int16)pOutliner->GetAbsPos( pPara );

		getMainSequence()->disposeTextRange( makeAny( aTarget ) );
	}
}

/** callback from the sd::View when an object just left text edit mode */
void SdPage::onEndTextEdit( SdrObject* pObj )
{
	if( pObj && mxAnimationNode.is() )
	{
		Reference< XShape > xObj( pObj->getUnoShape(), UNO_QUERY );
		getMainSequence()->onTextChanged( xObj );
	}
}

void SdPage::cloneAnimations( SdPage& rTargetPage ) const
{
	if( mxAnimationNode.is() )
	{
		Reference< XAnimationNode > xClonedNode(
			::sd::Clone( mxAnimationNode, this, &rTargetPage ) );

		if( xClonedNode.is() )
			rTargetPage.setAnimationNode( xClonedNode );
	}
}

