/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"

// System - Includes -----------------------------------------------------



// INCLUDE ---------------------------------------------------------------

#include "tabsplit.hxx"
#include "viewdata.hxx"
#include "dbfunc.hxx"

//==================================================================

ScTabSplitter::ScTabSplitter( Window* pParent, WinBits nWinStyle, ScViewData* pData ) :
	Splitter( pParent, nWinStyle ),
	pViewData(pData)
{
	SetFixed(sal_False);
	EnableRTL( sal_False );
}


ScTabSplitter::~ScTabSplitter()
{
}

void __EXPORT ScTabSplitter::MouseMove( const MouseEvent& rMEvt )
{
	if (bFixed)
		Window::MouseMove( rMEvt );
	else
		Splitter::MouseMove( rMEvt );
}

void __EXPORT ScTabSplitter::MouseButtonUp( const MouseEvent& rMEvt )
{
	if (bFixed)
		Window::MouseButtonUp( rMEvt );
	else
		Splitter::MouseButtonUp( rMEvt );
}

void __EXPORT ScTabSplitter::MouseButtonDown( const MouseEvent& rMEvt )
{
	if (bFixed)
		Window::MouseButtonDown( rMEvt );
	else
		Splitter::MouseButtonDown( rMEvt );
}

void __EXPORT ScTabSplitter::Splitting( Point& rSplitPos )
{
	Window* pParent = GetParent();
	Point aScreenPos = pParent->OutputToNormalizedScreenPixel( rSplitPos );
	pViewData->GetView()->SnapSplitPos( aScreenPos );
	Point aNew = pParent->NormalizedScreenToOutputPixel( aScreenPos );
	if ( IsHorizontal() )
		rSplitPos.X() = aNew.X();
	else
		rSplitPos.Y() = aNew.Y();
}


void ScTabSplitter::SetFixed(sal_Bool bSet)
{
	bFixed = bSet;
	if (bSet)
		SetPointer(POINTER_ARROW);
	else if (IsHorizontal())
		SetPointer(POINTER_HSPLIT);
	else
		SetPointer(POINTER_VSPLIT);
}



