/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef SCUI_TPHFEDIT_HXX
#define SCUI_TPHFEDIT_HXX

#include "tphfedit.hxx"

//===================================================================
enum ScHFEntryId
{
    eNoneEntry  ,          
    ePageEntry  ,          
    ePagesEntry ,
    eSheetEntry ,
    eConfidentialEntry ,
    eFileNamePageEntry ,
    eExtFileNameEntry ,
    ePageSheetEntry  ,          
    ePageFileNameEntry  ,          
    ePageExtFileNameEntry  ,          
    eUserNameEntry  ,          
    eCreatedByEntry ,  
    eEntryCount  
};

class ScHeaderEditEngine;
class ScPatternAttr;
class EditView;
class EditTextObject;
class SvxFieldItem;
class ScAccessibleEditObject;


class ScHFEditPage : public SfxTabPage
{
public:
	virtual	sal_Bool	FillItemSet	( SfxItemSet& rCoreSet );
	virtual	void	Reset		( const SfxItemSet& rCoreSet );

	void			SetNumType(SvxNumType eNumType);
	void			ClearTextAreas();

protected:
				ScHFEditPage( Window*			pParent,
							  sal_uInt16			nResId,
							  const SfxItemSet&	rCoreSet,
							  sal_uInt16			nWhich, bool bHeader );
	virtual		~ScHFEditPage();

private:
	FixedText		aFtLeft;
	ScEditWindow	aWndLeft;
	FixedText		aFtCenter;
	ScEditWindow	aWndCenter;
	FixedText		aFtRight;
	ScEditWindow	aWndRight;
	FixedText		maFtDefinedHF;
        ListBox                 maLbDefined;
	FixedText		maFtCustomHF;
	ImageButton		aBtnText;
	ScExtIButton	aBtnFile;
	ImageButton		aBtnTable;
	ImageButton		aBtnPage;
	ImageButton		aBtnLastPage;
	ImageButton		aBtnDate;
	ImageButton		aBtnTime;
	FixedLine		aFlInfo;
	FixedInfo		aFtInfo;
	ScPopupMenu		aPopUpFile;

	sal_uInt16			nWhich;
	String			aCmdArr[6];
	DECL_LINK( ObjectSelectHdl, ScEditWindow* );

private:
#ifdef _TPHFEDIT_CXX
	void FillCmdArr();
	void InitPreDefinedList();
	void ProcessDefinedListSel(ScHFEntryId eSel, bool bTravelling = false);
	void InsertToDefinedList();
	void RemoveFromDefinedList();
	void SetSelectDefinedList();
	bool IsPageEntry(EditEngine*pEngine, EditTextObject* pTextObj);
	bool IsDateEntry(EditTextObject* pTextObj);
	bool IsExtFileNameEntry(EditTextObject* pTextObj);
	DECL_LINK( ListHdl_Impl, ListBox* );
	DECL_LINK( ClickHdl, ImageButton* );
	DECL_LINK( MenuHdl, ScExtIButton* );
#endif
};

//===================================================================

class ScRightHeaderEditPage : public ScHFEditPage
{
public:
	static SfxTabPage*	Create( Window* pParent, const SfxItemSet& rCoreSet );
	static sal_uInt16*		GetRanges();

private:
	ScRightHeaderEditPage( Window* pParent, const SfxItemSet& rSet );
};

//===================================================================

class ScLeftHeaderEditPage : public ScHFEditPage
{
public:
	static SfxTabPage*	Create( Window* pParent, const SfxItemSet& rCoreSet );
	static sal_uInt16*		GetRanges();

private:
	ScLeftHeaderEditPage( Window* pParent, const SfxItemSet& rSet );
};

//===================================================================

class ScRightFooterEditPage : public ScHFEditPage
{
public:
	static SfxTabPage*	Create( Window* pParent, const SfxItemSet& rCoreSet );
	static sal_uInt16*		GetRanges();

private:
	ScRightFooterEditPage( Window* pParent, const SfxItemSet& rSet );
};

//===================================================================

class ScLeftFooterEditPage : public ScHFEditPage
{
public:
	static SfxTabPage*	Create( Window* pParent, const SfxItemSet& rCoreSet );
	static sal_uInt16*		GetRanges();

private:
	ScLeftFooterEditPage( Window* pParent, const SfxItemSet& rSet );
};

#endif

