/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef SC_FUMARK_HXX
#define SC_FUMARK_HXX

#include "fupoor.hxx"
#include "rangelst.hxx"			// ScRangeListRef


/*************************************************************************
|*
|* Funktion zum Aufziehen eines Rechtecks
|*
\************************************************************************/

class FuMarkRect : public FuPoor
{
 protected:
	Point			aBeginPos;
	Rectangle		aZoomRect;
	sal_Bool			bVisible;
	sal_Bool			bStartDrag;
	ScRangeListRef	aSourceRange;

 public:
	FuMarkRect(ScTabViewShell* pViewSh, Window* pWin, ScDrawView* pView,
		   SdrModel* pDoc, SfxRequest& rReq);
	virtual ~FuMarkRect();

	virtual sal_Bool KeyInput(const KeyEvent& rKEvt);

	virtual void ScrollStart();
	virtual void ScrollEnd();

	virtual void Activate();
	virtual void Deactivate();

	virtual void ForcePointer(const MouseEvent* pMEvt);

	virtual sal_Bool MouseMove(const MouseEvent& rMEvt);
	virtual sal_Bool MouseButtonUp(const MouseEvent& rMEvt);
	virtual sal_Bool MouseButtonDown(const MouseEvent& rMEvt);
	virtual sal_uInt8 Command(const CommandEvent& rCEvt);
};



#endif

