/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/




#ifndef _SC_ACCESSIBLECELLBASE_HXX
#define _SC_ACCESSIBLECELLBASE_HXX

#include "AccessibleContextBase.hxx"
#include "global.hxx"
#include "address.hxx"
#include <com/sun/star/accessibility/XAccessibleValue.hpp>
#include <cppuhelper/implbase1.hxx>

class ScTabViewShell;

typedef cppu::ImplHelper1< ::com::sun::star::accessibility::XAccessibleValue>
					ScAccessibleCellBaseImpl;

class ScAccessibleCellBase
	:	public ScAccessibleContextBase,
		public ScAccessibleCellBaseImpl
{
public:
	//=====  internal  ========================================================
	ScAccessibleCellBase(
        const ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible>& rxParent,
		ScDocument* pDoc,
		const ScAddress& rCellAddress,
		sal_Int32 nIndex);
protected:
	virtual ~ScAccessibleCellBase();
public:

	///=====  XInterface  =====================================================

	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( 
		::com::sun::star::uno::Type const & rType ) 
		throw (::com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire() throw ();
       
	virtual void SAL_CALL release() throw ();

	///=====  XAccessibleComponent  ============================================

    virtual sal_Bool SAL_CALL isVisible(  )
		throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL getForeground(  ) 
        throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL getBackground(  ) 
        throw (::com::sun::star::uno::RuntimeException);

    ///=====  XAccessibleContext  ==============================================

    ///	Return this objects index among the parents children.
	virtual	sal_Int32 SAL_CALL
    	getAccessibleIndexInParent(void)
        throw (::com::sun::star::uno::RuntimeException);

protected:
    ///	Return this object's description.
	virtual ::rtl::OUString SAL_CALL
    	createAccessibleDescription(void)
        throw (::com::sun::star::uno::RuntimeException);

    ///	Return the object's current name.
	virtual ::rtl::OUString SAL_CALL
    	createAccessibleName(void)
        throw (::com::sun::star::uno::RuntimeException);

public:
	///=====  XAccessibleValue  ================================================

    virtual ::com::sun::star::uno::Any SAL_CALL
		getCurrentValue(  )
		throw (::com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL
		setCurrentValue( const ::com::sun::star::uno::Any& aNumber )
		throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Any SAL_CALL
		getMaximumValue(  )
		throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Any SAL_CALL
		getMinimumValue(  )
		throw (::com::sun::star::uno::RuntimeException);

	///=====  XServiceInfo  ====================================================

    /**	Returns an identifier for the implementation of this object.
    */
	virtual ::rtl::OUString SAL_CALL
    	getImplementationName(void)
        throw (::com::sun::star::uno::RuntimeException);

	///=====  XTypeProvider  ===================================================

	/// returns the possible types
    virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL 
		getTypes() 
		throw (::com::sun::star::uno::RuntimeException);

	/**	Returns a implementation id.
    */
    virtual ::com::sun::star::uno::Sequence<sal_Int8> SAL_CALL
        getImplementationId(void)
        throw (::com::sun::star::uno::RuntimeException);

protected:
	ScAddress maCellAddress;

	ScDocument* mpDoc;

	sal_Int32 mnIndex;

private:
	virtual sal_Bool IsEditable(
		const com::sun::star::uno::Reference<
		::com::sun::star::accessibility::XAccessibleStateSet>& rxParentStates);
protected:
	virtual ::rtl::OUString SAL_CALL GetNote(void)
        throw (::com::sun::star::uno::RuntimeException);

	virtual ::rtl::OUString SAL_CALL GetAllDisplayNote(void)
        throw (::com::sun::star::uno::RuntimeException);
	virtual ::rtl::OUString SAL_CALL getShadowAttrs(void) 
		throw (::com::sun::star::uno::RuntimeException);
	virtual ::rtl::OUString SAL_CALL getBorderAttrs(void) 
		throw (::com::sun::star::uno::RuntimeException);
public:
	const ScAddress& GetCellAddress() const { return maCellAddress; }
	sal_Bool IsCellInChangeTrack(const ScAddress &cell,Color *pColCellBoder);
};
	


#endif
