/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"

#include "fuconarc.hxx"
#include "sc.hrc"
#include "tabvwsh.hxx"
#include "drawview.hxx"

// #98185# Create default drawing objects via keyboard
#include <svx/svdocirc.hxx>
#include <svx/sxciaitm.hxx>

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuConstArc::FuConstArc( ScTabViewShell* pViewSh, Window* pWin, ScDrawView* pViewP,
				   SdrModel* pDoc, SfxRequest& rReq )
    : FuConstruct( pViewSh, pWin, pViewP, pDoc, rReq )
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

FuConstArc::~FuConstArc()
{
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

sal_Bool __EXPORT FuConstArc::MouseButtonDown( const MouseEvent& rMEvt )
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	sal_Bool bReturn = FuConstruct::MouseButtonDown( rMEvt );

	if ( rMEvt.IsLeft() && !pView->IsAction() )
	{
		Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pWindow->CaptureMouse();
		pView->BegCreateObj( aPnt );
		bReturn = sal_True;
	}
	return bReturn;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

sal_Bool __EXPORT FuConstArc::MouseMove( const MouseEvent& rMEvt )
{
	return FuConstruct::MouseMove(rMEvt);
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

sal_Bool __EXPORT FuConstArc::MouseButtonUp( const MouseEvent& rMEvt )
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	sal_Bool bReturn = sal_False;

	if ( pView->IsCreateObj() && rMEvt.IsLeft() )
	{
		// Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pView->EndCreateObj( SDRCREATE_NEXTPOINT );
		bReturn = sal_True;
	}
/*
	else if ( pView->IsCreateObj() && rMEvt.IsRight() )
	{
		// Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pView->EndCreateObj( SDRCREATE_FORCEEND );
		bReturn = sal_True;
	}
*/
	return (FuConstruct::MouseButtonUp(rMEvt) || bReturn);
}

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert sal_True, andernfalls
|* FALSE.
|*
\************************************************************************/

sal_Bool __EXPORT FuConstArc::KeyInput(const KeyEvent& rKEvt)
{
	sal_Bool bReturn = FuConstruct::KeyInput(rKEvt);
	return(bReturn);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void FuConstArc::Activate()
{
	SdrObjKind aObjKind;

	switch (aSfxRequest.GetSlot() )
	{
		case SID_DRAW_ARC:
			aNewPointer = Pointer( POINTER_DRAW_ARC );
			aObjKind = OBJ_CARC;
			break;

		case SID_DRAW_PIE:
			aNewPointer = Pointer( POINTER_DRAW_PIE );
			aObjKind = OBJ_SECT;
			break;

		case SID_DRAW_CIRCLECUT:
			aNewPointer = Pointer( POINTER_DRAW_CIRCLECUT );
			aObjKind = OBJ_CCUT;
			break;

		default:
			aNewPointer = Pointer( POINTER_CROSS );
			aObjKind = OBJ_CARC;
			break;
	}

    pView->SetCurrentObj( sal::static_int_cast<sal_uInt16>( aObjKind ) );

	aOldPointer = pWindow->GetPointer();
	pViewShell->SetActivePointer( aNewPointer );

	FuDraw::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void FuConstArc::Deactivate()
{
	FuDraw::Deactivate();
	pViewShell->SetActivePointer( aOldPointer );
}

// #98185# Create default drawing objects via keyboard
SdrObject* FuConstArc::CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle)
{
	// case SID_DRAW_ARC:
	// case SID_DRAW_PIE:
	// case SID_DRAW_CIRCLECUT:

	SdrObject* pObj = SdrObjFactory::MakeNewObject(
		pView->GetCurrentObjInventor(), pView->GetCurrentObjIdentifier(),
		0L, pDrDoc);

	if(pObj)
	{
		if(pObj->ISA(SdrCircObj))
		{
			Rectangle aRect(rRectangle);

			if(SID_DRAW_ARC == nID || SID_DRAW_CIRCLECUT == nID)
			{
				// force quadratic
				ImpForceQuadratic(aRect);
			}

			pObj->SetLogicRect(aRect);

			SfxItemSet aAttr(pDrDoc->GetItemPool());
			aAttr.Put(SdrCircStartAngleItem(9000));
			aAttr.Put(SdrCircEndAngleItem(0));

			pObj->SetMergedItemSet(aAttr);
		}
		else
		{
			DBG_ERROR("Object is NO circle object");
		}
	}

	return pObj;
}


