/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



//------------------------------------------------------------------

#include "scitems.hxx"
#include <svx/drawitem.hxx>
#include <svx/fontwork.hxx>
#include <svx/svdotext.hxx>
#include <svx/xdef.hxx>
#include <sfx2/objsh.hxx>
#include <sfx2/viewfrm.hxx>
#include <svx/svdoashp.hxx>
#include "drawsh.hxx"
#include "drawview.hxx"
#include "viewdata.hxx"
#include "tabvwsh.hxx"
#include "sc.hrc"


//------------------------------------------------------------------

void ScDrawShell::GetFormTextState(SfxItemSet& rSet)
{
	const SdrObject*	pObj		= NULL;
	SvxFontWorkDialog*	pDlg		= NULL;
	ScDrawView* 		pDrView 	= pViewData->GetScDrawView();
	const SdrMarkList&	rMarkList	= pDrView->GetMarkedObjectList();
	sal_uInt16				nId = SvxFontWorkChildWindow::GetChildWindowId();

	SfxViewFrame* pViewFrm = pViewData->GetViewShell()->GetViewFrame();
	if ( pViewFrm->HasChildWindow(nId) )
		pDlg = (SvxFontWorkDialog*)(pViewFrm->GetChildWindow(nId)->GetWindow());

	if ( rMarkList.GetMarkCount() == 1 )
		pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();

    const SdrTextObj* pTextObj = dynamic_cast< const SdrTextObj* >(pObj);
    const bool bDeactivate(
        !pObj ||
        !pTextObj ||
        !pTextObj->HasText() ||
        dynamic_cast< const SdrObjCustomShape* >(pObj)); // #121538# no FontWork for CustomShapes

    if(bDeactivate)
	{
		if ( pDlg )
			pDlg->SetActive(sal_False);

		rSet.DisableItem(XATTR_FORMTXTSTYLE);
		rSet.DisableItem(XATTR_FORMTXTADJUST);
		rSet.DisableItem(XATTR_FORMTXTDISTANCE);
		rSet.DisableItem(XATTR_FORMTXTSTART);
		rSet.DisableItem(XATTR_FORMTXTMIRROR);
		rSet.DisableItem(XATTR_FORMTXTHIDEFORM);
		rSet.DisableItem(XATTR_FORMTXTOUTLINE);
		rSet.DisableItem(XATTR_FORMTXTSHADOW);
		rSet.DisableItem(XATTR_FORMTXTSHDWCOLOR);
		rSet.DisableItem(XATTR_FORMTXTSHDWXVAL);
		rSet.DisableItem(XATTR_FORMTXTSHDWYVAL);
	}
	else
	{
		if ( pDlg )
		{
			SfxObjectShell* pDocSh = SfxObjectShell::Current();

			if ( pDocSh )
			{
                const SfxPoolItem*  pItem = pDocSh->GetItem( SID_COLOR_TABLE );
				XColorListSharedPtr aColorTable;

				if ( pItem )
					aColorTable = static_cast< const SvxColorTableItem* >(pItem)->GetColorTable();

				pDlg->SetActive();

				if ( aColorTable.get() )
					pDlg->SetColorTable( aColorTable );
				else
					{ DBG_ERROR( "ColorList not found :-/" ); }
			}
		}
		SfxItemSet aViewAttr(pDrView->GetModel()->GetItemPool());
		pDrView->GetAttributes(aViewAttr);
		rSet.Set(aViewAttr);
	}
}



