/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



#include "editable.hxx"
#include "document.hxx"
#include "viewfunc.hxx"
#include "globstr.hrc"

//------------------------------------------------------------------

ScEditableTester::ScEditableTester() :
	bIsEditable( sal_True ),
	bOnlyMatrix( sal_True )
{
}

ScEditableTester::ScEditableTester( ScDocument* pDoc, SCTAB nTab,
						SCCOL nStartCol, SCROW nStartRow, SCCOL nEndCol, SCROW nEndRow ) :
	bIsEditable( sal_True ),
	bOnlyMatrix( sal_True )
{
	TestBlock( pDoc, nTab, nStartCol, nStartRow, nEndCol, nEndRow );
}

ScEditableTester::ScEditableTester( ScDocument* pDoc, 
						SCCOL nStartCol, SCROW nStartRow, SCCOL nEndCol, SCROW nEndRow,
						const ScMarkData& rMark ) :
	bIsEditable( sal_True ),
	bOnlyMatrix( sal_True )
{
	TestSelectedBlock( pDoc, nStartCol, nStartRow, nEndCol, nEndRow, rMark );
}

ScEditableTester::ScEditableTester( ScDocument* pDoc, const ScRange& rRange ) :
	bIsEditable( sal_True ),
	bOnlyMatrix( sal_True )
{
	TestRange( pDoc, rRange );
}

ScEditableTester::ScEditableTester( ScDocument* pDoc, const ScMarkData& rMark ) :
	bIsEditable( sal_True ),
	bOnlyMatrix( sal_True )
{
	TestSelection( pDoc, rMark );
}

ScEditableTester::ScEditableTester( ScViewFunc* pView ) :
	bIsEditable( sal_True ),
	bOnlyMatrix( sal_True )
{
	TestView( pView );
}

//------------------------------------------------------------------

void ScEditableTester::TestBlock( ScDocument* pDoc, SCTAB nTab,
						SCCOL nStartCol, SCROW nStartRow, SCCOL nEndCol, SCROW nEndRow )
{
	if ( bIsEditable || bOnlyMatrix )
	{
		sal_Bool bThisMatrix;
		if ( !pDoc->IsBlockEditable( nTab, nStartCol, nStartRow, nEndCol, nEndRow, &bThisMatrix ) )
		{
			bIsEditable = sal_False;
			if ( !bThisMatrix )
				bOnlyMatrix = sal_False;
		}
	}
}

void ScEditableTester::TestSelectedBlock( ScDocument* pDoc, 
						SCCOL nStartCol, SCROW nStartRow, SCCOL nEndCol, SCROW nEndRow,
						const ScMarkData& rMark )
{
	SCTAB nTabCount = pDoc->GetTableCount();
	for (SCTAB nTab=0; nTab<nTabCount; nTab++)
		if (rMark.GetTableSelect(nTab))
			TestBlock( pDoc, nTab, nStartCol, nStartRow, nEndCol, nEndRow );
}

void ScEditableTester::TestRange( ScDocument* pDoc, const ScRange& rRange )
{
	SCCOL nStartCol = rRange.aStart.Col();
	SCROW nStartRow = rRange.aStart.Row();
	SCTAB nStartTab = rRange.aStart.Tab();
	SCCOL nEndCol = rRange.aEnd.Col();
	SCROW nEndRow = rRange.aEnd.Row();
	SCTAB nEndTab = rRange.aEnd.Tab();
	for (SCTAB nTab=nStartTab; nTab<=nEndTab; nTab++)
		TestBlock( pDoc, nTab, nStartCol, nStartRow, nEndCol, nEndRow );
}

void ScEditableTester::TestSelection( ScDocument* pDoc, const ScMarkData& rMark )
{
	if ( bIsEditable || bOnlyMatrix )
	{
		sal_Bool bThisMatrix;
		if ( !pDoc->IsSelectionEditable( rMark, &bThisMatrix ) )
		{
			bIsEditable = sal_False;
			if ( !bThisMatrix )
				bOnlyMatrix = sal_False;
		}
	}
}

void ScEditableTester::TestView( ScViewFunc* pView )
{
	if ( bIsEditable || bOnlyMatrix )
	{
		sal_Bool bThisMatrix;
		if ( !pView->SelectionEditable( &bThisMatrix ) )
		{
			bIsEditable = sal_False;
			if ( !bThisMatrix )
				bOnlyMatrix = sal_False;
		}
	}
}

//------------------------------------------------------------------

sal_uInt16 ScEditableTester::GetMessageId() const
{
	if (bIsEditable)
		return 0;
	else if (bOnlyMatrix)
		return STR_MATRIXFRAGMENTERR;
	else
		return STR_PROTECTIONERR;
}

