/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"

// System - Includes ---------------------------------------------------------



// INCLUDE -------------------------------------------------------------------

#include <vcl/morebtn.hxx>
#include <svtools/stdctrl.hxx>

#include "anyrefdg.hxx"
#include "rangeutl.hxx"
#include "dbcolect.hxx"
#include "viewdata.hxx"
#include "document.hxx"
#include "queryparam.hxx"

#define _FOPTMGR_CXX
#include "foptmgr.hxx"
#undef _FOPTMGR_CXX

//----------------------------------------------------------------------------

ScFilterOptionsMgr::ScFilterOptionsMgr(
								Dialog*				ptrDlg,
								ScViewData*			ptrViewData,
								const ScQueryParam&	refQueryData,
								MoreButton&			refBtnMore,
								CheckBox&			refBtnCase,
								CheckBox&			refBtnRegExp,
								CheckBox&			refBtnHeader,
								CheckBox&			refBtnUnique,
								CheckBox&			refBtnCopyResult,
								CheckBox&			refBtnDestPers,
								ListBox&			refLbCopyArea,
								Edit&				refEdCopyArea,
								formula::RefButton&		refRbCopyArea,
								FixedText&			refFtDbAreaLabel,
								FixedInfo&			refFtDbArea,
                                FixedLine&          refFlOptions,
								const String&		refStrNoName,
								const String&		refStrUndefined )

	:	pDlg			( ptrDlg ),
		pViewData		( ptrViewData ),
		pDoc			( ptrViewData ? ptrViewData->GetDocument() : NULL ),
		rBtnMore		( refBtnMore ),
		rBtnCase		( refBtnCase ),
		rBtnRegExp		( refBtnRegExp ),
		rBtnHeader		( refBtnHeader ),
		rBtnUnique		( refBtnUnique ),
		rBtnCopyResult	( refBtnCopyResult ),
		rBtnDestPers	( refBtnDestPers ),
		rLbCopyPos		( refLbCopyArea ),
		rEdCopyPos		( refEdCopyArea ),
		rRbCopyPos		( refRbCopyArea ),
		rFtDbAreaLabel	( refFtDbAreaLabel ),
		rFtDbArea		( refFtDbArea ),
        rFlOptions      ( refFlOptions ),
		rStrNoName		( refStrNoName ),
		rStrUndefined	( refStrUndefined ),
		rQueryData		( refQueryData )
{
	Init();
}


//----------------------------------------------------------------------------

ScFilterOptionsMgr::~ScFilterOptionsMgr()
{
	sal_uInt16 nEntries = rLbCopyPos.GetEntryCount();
	sal_uInt16 i;

	for ( i=2; i<nEntries; i++ )
		delete (String*)rLbCopyPos.GetEntryData( i );
}


//----------------------------------------------------------------------------

void ScFilterOptionsMgr::Init()
{
	DBG_ASSERT( pViewData && pDoc, "Init failed :-/" );

	rLbCopyPos.SetSelectHdl	 ( LINK( this, ScFilterOptionsMgr, LbPosSelHdl ) );
	rEdCopyPos.SetModifyHdl	 ( LINK( this, ScFilterOptionsMgr, EdPosModifyHdl ) );
	rBtnCopyResult.SetClickHdl( LINK( this, ScFilterOptionsMgr, BtnCopyResultHdl ) );

	rBtnMore.AddWindow( &rBtnCase );
	rBtnMore.AddWindow( &rBtnRegExp );
	rBtnMore.AddWindow( &rBtnHeader );
	rBtnMore.AddWindow( &rBtnUnique );
	rBtnMore.AddWindow( &rBtnCopyResult );
	rBtnMore.AddWindow( &rBtnDestPers );
	rBtnMore.AddWindow( &rLbCopyPos );
	rBtnMore.AddWindow( &rEdCopyPos );
	rBtnMore.AddWindow( &rRbCopyPos );
	rBtnMore.AddWindow( &rFtDbAreaLabel );
	rBtnMore.AddWindow( &rFtDbArea );
    rBtnMore.AddWindow( &rFlOptions );

	rBtnCase	.Check( rQueryData.bCaseSens );
	rBtnHeader	.Check( rQueryData.bHasHeader );
	rBtnRegExp	.Check( rQueryData.bRegExp );
	rBtnUnique	.Check( !rQueryData.bDuplicate );

	if ( pViewData && pDoc )
	{
		String			theAreaStr;
		ScRange			theCurArea ( ScAddress( rQueryData.nCol1,
												rQueryData.nRow1,
												pViewData->GetTabNo() ),
									 ScAddress( rQueryData.nCol2,
												rQueryData.nRow2,
												pViewData->GetTabNo() ) );
		ScDBCollection*	pDBColl		= pDoc->GetDBCollection();
		String			theDbArea;
		String			theDbName	= rStrNoName;
        const formula::FormulaGrammar::AddressConvention eConv = pDoc->GetAddressConvention();

		theCurArea.Format( theAreaStr, SCR_ABS_3D, pDoc, eConv );

		// Zielbereichsliste fuellen

		rLbCopyPos.Clear();
		rLbCopyPos.InsertEntry( rStrUndefined, 0 );

		ScAreaNameIterator aIter( pDoc );
		String aName;
		ScRange aRange;
		String aRefStr;
		while ( aIter.Next( aName, aRange ) )
		{
			sal_uInt16 nInsert = rLbCopyPos.InsertEntry( aName );

			aRange.aStart.Format( aRefStr, SCA_ABS_3D, pDoc, eConv );
			rLbCopyPos.SetEntryData( nInsert, new String( aRefStr ) );
		}

		rBtnDestPers.Check( sal_True );			// beim Aufruf immer an
		rLbCopyPos.SelectEntryPos( 0 );
		rEdCopyPos.SetText( EMPTY_STRING );

		/*
		 * Ueberpruefen, ob es sich bei dem uebergebenen
		 * Bereich um einen Datenbankbereich handelt:
		 */

		theDbArea = theAreaStr;

        if ( pDBColl )
        {
            ScAddress&	rStart	= theCurArea.aStart;
            ScAddress&	rEnd	= theCurArea.aEnd;
            ScDBData*	pDBData = pDBColl->GetDBAtArea(
                rStart.Tab(), rStart.Col(), rStart.Row(), rEnd.Col(), rEnd.Row() );
            if ( pDBData )
            {
                rBtnHeader.Check( pDBData->HasHeader() );
                pDBData->GetName( theDbName );

                if ( !pDBData->IsInternalUnnamed()
                     && !pDBData->IsInternalForAutoFilter() )
                {
                    rBtnHeader.Disable();
                }
            }
        }

		theDbArea.AppendAscii(RTL_CONSTASCII_STRINGPARAM(" ("));
		theDbArea += theDbName;
		theDbArea += ')';
		rFtDbArea.SetText( theDbArea );

		//------------------------------------------------------
		// Kopierposition:

		if ( !rQueryData.bInplace )
		{
			String aString;

			ScAddress( rQueryData.nDestCol,
					   rQueryData.nDestRow,
					   rQueryData.nDestTab
					 ).Format( aString, SCA_ABS_3D, pDoc, eConv );

			rBtnCopyResult.Check( sal_True );
			rEdCopyPos.SetText( aString );
			EdPosModifyHdl( &rEdCopyPos );
			rLbCopyPos.Enable();
			rEdCopyPos.Enable();
			rRbCopyPos.Enable();
			rBtnDestPers.Enable();
		}
		else
		{
			rBtnCopyResult.Check( sal_False );
			rEdCopyPos.SetText( EMPTY_STRING );
			rLbCopyPos.Disable();
			rEdCopyPos.Disable();
			rRbCopyPos.Disable();
			rBtnDestPers.Disable();
		}
	}
	else
		rEdCopyPos.SetText( EMPTY_STRING );
}


//----------------------------------------------------------------------------

sal_Bool ScFilterOptionsMgr::VerifyPosStr( const String& rPosStr ) const
{
	String aPosStr( rPosStr );
	xub_StrLen nColonPos = aPosStr.Search( ':' );

	if ( STRING_NOTFOUND != nColonPos )
		aPosStr.Erase( nColonPos );

	sal_uInt16 nResult = ScAddress().Parse( aPosStr, pDoc, pDoc->GetAddressConvention() );

	return ( SCA_VALID == (nResult & SCA_VALID) );
}


//----------------------------------------------------------------------------
// Handler:

//----------------------------------------------------------------------------

IMPL_LINK( ScFilterOptionsMgr, LbPosSelHdl, ListBox*, pLb )
{
	if ( pLb == &rLbCopyPos )
	{
		String aString;
		sal_uInt16 nSelPos = rLbCopyPos.GetSelectEntryPos();

		if ( nSelPos > 0 )
			aString = *(String*)rLbCopyPos.GetEntryData( nSelPos );

		rEdCopyPos.SetText( aString );
	}

	return 0;
}


//----------------------------------------------------------------------------

IMPL_LINK( ScFilterOptionsMgr, EdPosModifyHdl, Edit*, pEd )
{
	if ( pEd == &rEdCopyPos )
	{
		String	theCurPosStr = pEd->GetText();
		sal_uInt16	nResult = ScAddress().Parse( theCurPosStr, pDoc, pDoc->GetAddressConvention() );

		if ( SCA_VALID == (nResult & SCA_VALID) )
		{
			String*	pStr	= NULL;
			sal_Bool	bFound	= sal_False;
			sal_uInt16	i		= 0;
			sal_uInt16	nCount	= rLbCopyPos.GetEntryCount();

			for ( i=2; i<nCount && !bFound; i++ )
			{
				pStr = (String*)rLbCopyPos.GetEntryData( i );
				bFound = (theCurPosStr == *pStr);
			}

			if ( bFound )
				rLbCopyPos.SelectEntryPos( --i );
			else
				rLbCopyPos.SelectEntryPos( 0 );
		}
		else
			rLbCopyPos.SelectEntryPos( 0 );
	}

	return 0;
}


//----------------------------------------------------------------------------

IMPL_LINK( ScFilterOptionsMgr, BtnCopyResultHdl, CheckBox*, pBox )
{
	if ( pBox == &rBtnCopyResult )
	{
		if ( pBox->IsChecked() )
		{
			rBtnDestPers.Enable();
			rLbCopyPos.Enable();
			rEdCopyPos.Enable();
			rRbCopyPos.Enable();
			rEdCopyPos.GrabFocus();
		}
		else
		{
			rBtnDestPers.Disable();
			rLbCopyPos.Disable();
			rEdCopyPos.Disable();
			rRbCopyPos.Disable();
		}
	}

	return 0;
}
