/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"

#undef SC_DLLIMPLEMENTATION



//------------------------------------------------------------------

#include "dapitype.hxx"
#include "scresid.hxx"
#include "sc.hrc"
#include "dapitype.hrc"

using namespace com::sun::star;

//-------------------------------------------------------------------------

ScDataPilotSourceTypeDlg::ScDataPilotSourceTypeDlg( Window* pParent, sal_Bool bEnableExternal ) :
	ModalDialog     ( pParent, ScResId( RID_SCDLG_DAPITYPE ) ),
	//
    aFlFrame        ( this, ScResId( FL_FRAME ) ),
	aBtnSelection   ( this, ScResId( BTN_SELECTION ) ),
	aBtnDatabase    ( this, ScResId( BTN_DATABASE ) ),
	aBtnExternal    ( this, ScResId( BTN_EXTERNAL ) ),
	aBtnOk          ( this, ScResId( BTN_OK ) ),
	aBtnCancel      ( this, ScResId( BTN_CANCEL ) ),
	aBtnHelp        ( this, ScResId( BTN_HELP ) )
{
	if (!bEnableExternal)
		aBtnExternal.Disable();

	aBtnSelection.Check();

	FreeResource();
}

ScDataPilotSourceTypeDlg::~ScDataPilotSourceTypeDlg()
{
}

sal_Bool ScDataPilotSourceTypeDlg::IsDatabase() const
{
	return aBtnDatabase.IsChecked();
}

sal_Bool ScDataPilotSourceTypeDlg::IsExternal() const
{
	return aBtnExternal.IsChecked();
}

//-------------------------------------------------------------------------

ScDataPilotServiceDlg::ScDataPilotServiceDlg( Window* pParent,
								const uno::Sequence<rtl::OUString>& rServices ) :
	ModalDialog     ( pParent, ScResId( RID_SCDLG_DAPISERVICE ) ),
	//
    aFlFrame        ( this, ScResId( FL_FRAME ) ),
	aFtService      ( this, ScResId( FT_SERVICE ) ),
	aLbService      ( this, ScResId( LB_SERVICE ) ),
	aFtSource		( this, ScResId( FT_SOURCE ) ),
	aEdSource		( this, ScResId( ED_SOURCE ) ),
	aFtName			( this, ScResId( FT_NAME ) ),
	aEdName			( this, ScResId( ED_NAME ) ),
	aFtUser			( this, ScResId( FT_USER ) ),
	aEdUser			( this, ScResId( ED_USER ) ),
	aFtPasswd		( this, ScResId( FT_PASSWD ) ),
	aEdPasswd		( this, ScResId( ED_PASSWD ) ),
	aBtnOk          ( this, ScResId( BTN_OK ) ),
	aBtnCancel      ( this, ScResId( BTN_CANCEL ) ),
	aBtnHelp        ( this, ScResId( BTN_HELP ) )
{
	long nCount = rServices.getLength();
	const rtl::OUString* pArray = rServices.getConstArray();
	for (long i=0; i<nCount; i++)
	{
		String aName = pArray[i];
		aLbService.InsertEntry( aName );
	}
	aLbService.SelectEntryPos( 0 );

	FreeResource();
}

ScDataPilotServiceDlg::~ScDataPilotServiceDlg()
{
}

String ScDataPilotServiceDlg::GetServiceName() const
{
	return aLbService.GetSelectEntry();
}

String ScDataPilotServiceDlg::GetParSource() const
{
	return aEdSource.GetText();
}

String ScDataPilotServiceDlg::GetParName() const
{
	return aEdName.GetText();
}

String ScDataPilotServiceDlg::GetParUser() const
{
	return aEdUser.GetText();
}

String ScDataPilotServiceDlg::GetParPass() const
{
	return aEdPasswd.GetText();
}



