/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



// INCLUDE ---------------------------------------------------------------
#include "XMLTableSourceContext.hxx"
#include "xmlimprt.hxx"
#include "document.hxx"
#include "xmlsubti.hxx"
#include "tablink.hxx"
#include <xmloff/xmltoken.hxx>
#include <xmloff/xmlnmspe.hxx>
#include <xmloff/nmspmap.hxx>
#include <xmloff/xmluconv.hxx>
#include <com/sun/star/sheet/XSheetLinkable.hpp>

using namespace com::sun::star;
using namespace xmloff::token;

//------------------------------------------------------------------

ScXMLTableSourceContext::ScXMLTableSourceContext( ScXMLImport& rImport,
									  sal_uInt16 nPrfx,
									  const ::rtl::OUString& rLName,
									  const ::com::sun::star::uno::Reference<
									  ::com::sun::star::xml::sax::XAttributeList>& xAttrList) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	sLink(),
	sTableName(),
	sFilterName(),
	sFilterOptions(),
	nRefresh(0),
	nMode(sheet::SheetLinkMode_NORMAL)
{
	sal_Int16 nAttrCount(xAttrList.is() ? xAttrList->getLength() : 0);
	for( sal_Int16 i=0; i < nAttrCount; ++i )
	{
		const rtl::OUString& sAttrName(xAttrList->getNameByIndex( i ));
		rtl::OUString aLocalName;
		sal_uInt16 nPrefix(GetScImport().GetNamespaceMap().GetKeyByAttrName(
											sAttrName, &aLocalName ));
		const rtl::OUString& sValue(xAttrList->getValueByIndex( i ));
		if(nPrefix == XML_NAMESPACE_XLINK)
		{
			if (IsXMLToken(aLocalName, XML_HREF))
				sLink = GetScImport().GetAbsoluteReference(sValue);
		}
		else if (nPrefix == XML_NAMESPACE_TABLE)
		{
			if (IsXMLToken(aLocalName, XML_TABLE_NAME))
				sTableName = sValue;
			else if (IsXMLToken(aLocalName, XML_FILTER_NAME))
				sFilterName = sValue;
			else if (IsXMLToken(aLocalName, XML_FILTER_OPTIONS))
				sFilterOptions = sValue;
			else if (IsXMLToken(aLocalName, XML_MODE))
			{
				if (IsXMLToken(sValue, XML_COPY_RESULTS_ONLY))
					nMode = sheet::SheetLinkMode_VALUE;
			}
			else if (IsXMLToken(aLocalName, XML_REFRESH_DELAY))
			{
				double fTime;
				if( SvXMLUnitConverter::convertTime( fTime, sValue ) )
					nRefresh = Max( (sal_Int32)(fTime * 86400.0), (sal_Int32)0 );
			}
		}
	}
}

ScXMLTableSourceContext::~ScXMLTableSourceContext()
{
}

SvXMLImportContext *ScXMLTableSourceContext::CreateChildContext( sal_uInt16 nPrefix,
											const ::rtl::OUString& rLName,
											const ::com::sun::star::uno::Reference<
                                        ::com::sun::star::xml::sax::XAttributeList>& /* xAttrList */ )
{
	return new SvXMLImportContext( GetImport(), nPrefix, rLName );
}

void ScXMLTableSourceContext::EndElement()
{
	if (sLink.getLength())
	{
		uno::Reference <sheet::XSheetLinkable> xLinkable (GetScImport().GetTables().GetCurrentXSheet(), uno::UNO_QUERY);
		ScDocument* pDoc(GetScImport().GetDocument());
		if (xLinkable.is() && pDoc)
		{
			GetScImport().LockSolarMutex();
			if (pDoc->RenameTab( static_cast<SCTAB>(GetScImport().GetTables().GetCurrentSheet()),
				GetScImport().GetTables().GetCurrentSheetName(), sal_False, sal_True))
			{
		 		String aFileString(sLink);
				String aFilterString(sFilterName);
				String aOptString(sFilterOptions);
				String aSheetString(sTableName);

				aFileString = ScGlobal::GetAbsDocName( aFileString, pDoc->GetDocumentShell() );
				if ( !aFilterString.Len() )
                    ScDocumentLoader::GetFilterName( aFileString, aFilterString, aOptString, sal_False, sal_False );

				sal_uInt8 nLinkMode = SC_LINK_NONE;
				if ( nMode == sheet::SheetLinkMode_NORMAL )
					nLinkMode = SC_LINK_NORMAL;
				else if ( nMode == sheet::SheetLinkMode_VALUE )
					nLinkMode = SC_LINK_VALUE;

				pDoc->SetLink( static_cast<SCTAB>(GetScImport().GetTables().GetCurrentSheet()),
					nLinkMode, aFileString, aFilterString, aOptString,
					aSheetString, nRefresh );
			}
			GetScImport().UnlockSolarMutex();
		}
	}
}

